/*-----------------------------------------------------------------------------
 * res2nfas.cc
 * Convert regular expressions to NFA's
 * 
 *
 * Author:  Liu Yang
 * Date:    Jan 5, 2010
 *
 *-----------------------------------------------------------------------------
 * $Log: res2nfas.cc,v $
 * Revision 1.3  2010/09/27 14:48:31  lyangru
 * final synchronization
 *
 *
 *---------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <iostream>
#include <sys/time.h>
#include <sys/resource.h>
#include "nodes.h"
#include "re.h"
#include "nfa.h"
#include "globals.h"

#define DEBUG

nfa_t *NFA = NULL;

int cputime();

/*-----------------------------------------------------------------------------
 * main
 *---------------------------------------------------------------------------*/
int main(int argc, char *argv[])
{
   FILE *f;
   char buf[4096];
   char *p;
   int line = 1;
   nfa_t *tmp_nfa;
   int i = 0;
   unsigned long start = 0, end = 0;

   if (argc != 3) {
      printf("usage: %s <regex file name> <output file name>\n", argv[0]);
      return -1;
   }

   if ( (f=fopen(argv[1], "r")) == NULL) {
      printf("failed to open file %s\n", argv[1]);
      exit(0);
   }

   start = cputime();

   p = fgets(buf, 4096, f);
   while (p != NULL) {
#ifdef DEBUG
      i++;
//      if ((i % 10) == 0)
        printf("The %dth regular expression ...\n", i);
#endif      
      p[strlen(p)-1] = '\0';  /* get rid of trailing \n */
      NFA = re_to_nfa(buf, strlen(buf), line, line++);
      NFA->bdd_output(argv[2], 42);	
      delete NFA;
      memset(buf, 0, 4096);
      p = fgets(buf, 4096, f);
   }

   end = cputime();
   fclose(f);
   cout << "Time used for NFA combination: " << (double)(end - start) / (double)1000 << " seconds" << endl;

   return 1;
}

int cputime()
{
  struct rusage rus;

  getrusage (RUSAGE_SELF, &rus);
  return rus.ru_utime.tv_sec * 1000 + rus.ru_utime.tv_usec / 1000;
}


