
/*------------------------------------------------------------------------
 * File:	nfaToBDD.h
 *
 * Author:	Rezwana Karim
 * Date:	August 20, 2009
 *
 * ------------------------------------------------------------------------
 * Header file for nfaToBDD.cpp
 *-------------------------------------------------------------------------
 * Declared NFAToBDD class which provide utility functions for
 * 1. Reading epsilon-free NFA information from file 
 * 2. Encoding the NFA using binary encoding
 * 3. Constructing BDDs corresponding to 
 *        transition function
 *        set of start states
 *        set of accepting states
 *        individual accept states
 *        input symbols
 * 4. Dumping the BDDs to disk       
 *          
 *--------------------------------------------------------------------------
 * 
 **/



#include <iostream>
#include <fstream>
#include <string.h>


/*Set these file paths appropriately based on where the CUDD package lies*/

#include "../../cudd-2.4.2/include/cuddObj.hh"
#include "../../cudd-2.4.2/include/cuddInt.h"
#include "../../cudd-2.4.2/dddmp/dddmpInt.h"

#include <boost/dynamic_bitset.hpp>

#define NUM_COLUMN	3
/*---------------------------------------------------------------------------*/
/* Stucture declarations                                                     */
/*---------------------------------------------------------------------------*/
typedef struct dddmpVarInfo {
  /*
   *  Local Information
   */

  int nDdVars;       /* Local Manager Number of Variables */
  char **rootNames;  /* Root Names */

  /*
   *  Header File Information
   */

  Dddmp_DecompType ddType;

  int nVars;      /* File Manager Number of Variables */
  int nSuppVars;  /* File Structure Number of Variables */

  int varNamesFlagUpdate;      /* 0 to NOT Update */
  char **suppVarNames;
  char **orderedVarNames;

  int varIdsFlagUpdate;        /* 0 to NOT Update */
  int *varIds;                 /* File ids - nSuppVars size */
  int *varIdsAll;              /* ALL ids - nVars size */

  int varComposeIdsFlagUpdate; /* 0 to NOT Update */
  int *varComposeIds;          /* File permids - nSuppVars size */
  int *varComposeIdsAll;       /* ALL permids - nVars size */

  int varAuxIdsFlagUpdate;     /* 0 to NOT Update */
  int *varAuxIds;              /* File auxids - nSuppVars size */
  int *varAuxIdsAll;           /* ALL auxids  - nVars size */

  int nRoots;
} dddmpVarInfo_t;


typedef struct stateSigIDPair{
   unsigned int state;
   unsigned int sigID;
}stateSigIDPair_t;


/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/
Dddmp_RootMatchType rootmatchmode;
Dddmp_VarMatchType varmatchmode;
Dddmp_VarInfoType varoutinfo;
// put the struct definition in a separate file

const int INPUT_ALPHABET_SIZE = 256;//256 ASCII values 
//#define INPUT_ALPHABET_SIZE 256 //also works

class NFAtoBDD{
public:
    DdManager *manager;
    DdNode **currentStateVar;
    DdNode **nextStateVar;
    DdNode **inputVar;
    DdNode **acceptStateBddArray;// array of bdds representing each Accepting state ...needed for detection of signature id
    
    dddmpVarInfo_t varInfo;
    stateSigIDPair_t *ssiPair;
    
    unsigned  int NO_OF_STATES;
    unsigned  int NO_OF_ACC_STATES;
    unsigned  int NO_OF_PAIRS;
    unsigned  int NO_OF_START_STATES;
   
    unsigned  int NO_OF_TRANSITIONS;
    
    unsigned short int INPUT_ENCODE_SIZE;
    unsigned  short int STATE_ENCODE_SIZE;
    
    int **T_transitions;
   
    boost::dynamic_bitset<> **binCurrentState;//current state info in binary encoded transition table
    boost::dynamic_bitset<> **binNextState;//next state info in binary encoded transition table
    boost::dynamic_bitset<> **binInput;//input info in binary encoded transition table
    
    unsigned  int* acceptSetOfStates;
    unsigned  int* startSetOfStates;
     
    //public:
    //NFAtoBDD():INPUT_ALPHABET_SIZE(257){ INPUT_ENCODE_SIZE=8;} will not work if bitset declared
    NFAtoBDD(){INPUT_ENCODE_SIZE=8;}
    FILE* readNFAFromFile(char *fileName );
    
    
    void initBddConstruct();
    int processTransitions(FILE*);
    DdNode* createTransitionChunkBDD(unsigned int);
    // DdNode* getNFATransitionFunction();
    DdNode* formStartSetOfStates();
    DdNode* formAcceptSetOfStates();
    DdNode** formAcceptStateBddArray();
    
    
    int storeBddArray(DdNode **outputBddArray);
    void storeAcceptStateBddArray(DdNode **acceptStateBddArray);
    void storeInputAlphabetBddArray();
    
    void storeNFAInfo();
    int storeTransFuncChunkBDD(DdNode* transFunc, int chunk_num);
    void storeStartSetOfStatesBDD(DdNode*);
    void storeAcceptSetOfStatesBDD(DdNode*);
    
    void freeMemory( DdNode **acceptStateBddArray);
    
    //debugging purpose
    void printTable();
    void printBinTable();
    
};

int cputime();

void getFileName(unsigned int chunk_num, char *fileName);
