
/*------------------------------------------------------------------------
 * File:	nfa_operation.h
 *
 * Author:	Rezwana Karim
 * Date:	August 20, 2009
 *
 *-------------------------------------------------------------------------------------------------------
 * header file for the nfa_operation.cpp
 *
 *        
 *
 *--------------------------------------------------------------------------------------------------------
 *
 * This file contains class NFAOperationByBDD
 * This class simulates the NFA operation on BDD based implementation
 * @Input to the class
 *     NFA properties expressed by a BDD
 * @Output
 *     String accepted or rejected
 *
 * */


#include <iostream>
#include <fstream>

#include <time.h>
#include <sys/time.h>
#include <sys/resource.h>

/*Set these file paths appropriately based on where the CUDD package lies*/

#include "../../cudd-2.4.2/include/cuddObj.hh"
#include "../../cudd-2.4.2/include/cuddInt.h"
#include "../../cudd-2.4.2/dddmp/dddmpInt.h"




/*---------------------------------------------------------------------------*/
/* Structure declarations                                                     */
/*---------------------------------------------------------------------------*/
typedef struct dddmpVarInfo {
  /*
   *  Local Information
   */

  int nDdVars;       /* Local Manager Number of Variables */
  char **rootNames;  /* Root Names */

  /*
   *  Header File Information
   */

  Dddmp_DecompType ddType;

  int nVars;      /* File Manager Number of Variables */
  int nSuppVars;  /* File Structure Number of Variables */

  int varNamesFlagUpdate;      /* 0 to NOT Update */
  char **suppVarNames;
  char **orderedVarNames;

  int varIdsFlagUpdate;        /* 0 to NOT Update */
  int *varIds;                 /* File ids - nSuppVars size */
  int *varIdsAll;              /* ALL ids - nVars size */

  int varComposeIdsFlagUpdate; /* 0 to NOT Update */
  int *varComposeIds;          /* File permids - nSuppVars size */
  int *varComposeIdsAll;       /* ALL permids - nVars size */

  int varAuxIdsFlagUpdate;     /* 0 to NOT Update */
  int *varAuxIds;              /* File auxids - nSuppVars size */
  int *varAuxIdsAll;           /* ALL auxids  - nVars size */

  int nRoots;
} dddmpVarInfo_t;


/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/
extern Dddmp_RootMatchType rootmatchmode;
extern Dddmp_VarMatchType varmatchmode;
extern Dddmp_VarInfoType varoutinfo;



const int INPUT_ALPHABET_SIZE=256;



class NFAOperationByBDD{
    //private members
public:
    DdManager *manager;
    DdNode *transFunc; //transition function of NFA
    DdNode *startSetOfStates;
    DdNode *acceptSetOfStates;
    
    DdNode *currentSetOfStates;
    DdNode *cubeForAbstract;
    
    DdNode **acceptStateBddArray;
    DdNode **inputSymbolBddArray;
    
    DdNode **currentStateVar;
    DdNode **nextStateVar;
    DdNode **inputVar;
    
    dddmpVarInfo_t varInfo;
    
    unsigned short int INPUT_ENCODE_SIZE;
    unsigned  short int STATE_ENCODE_SIZE;
    
    unsigned short int NO_OF_PAIRS;
    unsigned short int *signatureIDArray;
    
    
//public:
    
    NFAOperationByBDD(){}
    void readBddInfoFromFile( char* , char*);
    void initNFA();// initialize the NFA expressed by BDD and also set the mapping
    void formCubeForAbstract();
    void simulate(const unsigned char *buf, unsigned int len, bool check_detect);//simulate the NFA operation
    void checkAccept(unsigned int );//check Acceptance of the input stream
    void printBDD(DdNode *bdd, int n);//prints a BDD that depends on n variables
    void freeMemory();
    
};

void getFileName(unsigned int chunk_num, char *fileName);

int cputime();
