/*------------------------------------------------------------------------
 * File:	alpha_reduction_simul.cc
 *
 * Author:	Liu Yang
 * Date:	Sep 3, 2009
 *
 * Test simulation by doing alphabet reduction
 *------------------------------------------------------------------------
 * $Log: alphabet_reduction.cc,v $
 * Revision 1.3  2010/09/27 14:21:06  lyangru
 * final synchronization
 *
 *
 * */

#include <iostream>
#include <cstdlib>
#include <fstream>
#include <map>
#include <set>
#include <vector>

#include "nfa-multimap.h"

int main (int argc, char **argv) {
  int i;
  nfa_map_t nfa_dt;
  unsigned int t_start, t_end;

  if (argc != 3) {
    cerr << "Usage: alphabet_reduction <NFA file name> <reduced transition file name>" << endl;
    cout << "The NFA file should contains transitions of an NFA with epsilon transitions eliminated!" << endl;
    exit(1);
  }

  nfa_dt.fill_trans_tab(argv[1]);
  t_start = cputime();
  //nfa_dt.alphabet_reduction();
  nfa_dt.alphabet_reduction_im();
  /* generate the reduced transition table */
  nfa_dt.rdt_trans_tab_gen();
  t_end = cputime();
  nfa_dt.dump_rdt_transitions(argv[2]);

  cout << "Total time spent on alphabet reduction: " << (double)(t_end - t_start)/(double)1000 << " seconds" << endl;

  return 0;
}
