/*---------------------------------------------------------------------------
 * File:	direct_simulate_pkdd.cc
 *
 * Author:	Liu Yang
 * Date:	Jun 20, 2010
 *
 * Match test for different NFA implementations on PKDD07 traces
 *------------------------------------------------------------------------
 * $Log: direct_simulate_pkdd.cc,v $
 * Revision 1.1  2010/09/27 14:24:42  lyangru
 * for pkdd match test
 *
 *
 *
 *-----------------------------------------------------------------------*/


#include <iostream>
#include <fstream>
#include <map>
#include <set>
#include <vector>
#include <string>
#include <cstdlib>
#include <string.h>
#include <stdio.h>

#include <unistd.h>
#include <pcap.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <net/if.h>
#include <errno.h>

#include "nfa-multimap.h"
#include "clock.h"
#include "packet.h"
#include "decode.h"

#define BUF_SIZE		200000

//#define DEBUG

/* Choose ONE implementation when performing simulation */

//#define NFA_IMPLEMENTED_BY_SET	/* consumes most memory */
#define NFA_IMPLEMENTED_BY_PTR_SET 	/* the fastest method */
//#define NFA_IMPLEMENTED_BY_MULTIMAP	/* consumes least memory */
//#define NFA_IMPLEMENTED_BY_MAP

using namespace std;

string trace_file;

/*-----------------------------------------------
 * Function Prototypes
 *----------------------------------------------*/

int main(int argc, char** argv) {

  unsigned long long starttm = 0;
  unsigned long long stoptm = 0;
  unsigned long long total_cycles = 0;
  size_t total_bytes = 0;
  unsigned int t_start, t_end;
  size_t trans_tab_sz = 0;  
  string cur_payload, line;
  ifstream payload_file;

#ifdef NFA_IMPLEMENTED_BY_MULTIMAP
  nfa_trans_mm_t nfa_dt;
#elif defined(NFA_IMPLEMENTED_BY_MAP)
  nfa_map_t nfa_dt;
#else
  nfa_trans_set_t nfa_dt; /* NFA is implemented by set or ptrs to set */
#endif

  if (argc != 3) {
    cerr << "Usage: %s <NFA file name> <trace file>" << endl;
    cout << "The NFA file should contains transitions of an NFA with epsilon transitions eliminated!" << endl;
    exit(1);
  }

  /* fill out the transition table */
#ifdef NFA_IMPLEMENTED_BY_PTR_SET
  nfa_dt.fill_ptrans_tab(argv[1]);
#else
  nfa_dt.fill_trans_tab(argv[1]);
#endif

  /* ----read stream for match test---- */
  trace_file = argv[2];
  payload_file.open(&trace_file[0]);


  unsigned char *payload;
  size_t total_payload_bytes = 0;
  while (!payload_file.eof()) {
    getline(payload_file, line);
    if (line.compare(0, 17, "payload-dilimiter") != 0) {
      cur_payload += line + "\n";
    } else {
      rdtsc(starttm);
      #ifdef NFA_IMPLEMENTED_BY_PTR_SET
        nfa_dt.simulatep((unsigned char *)&(cur_payload[0]), cur_payload.size());
      #else
        nfa_dt.simulate((unsigned char *)&(cur_payload[0]), cur_payload.size());
      #endif
      rdtsc(stoptm);
      total_payload_bytes += cur_payload.size();
      total_cycles += (stoptm - starttm);
    
      cur_payload.clear();
      total_bytes += cur_payload.size();
    }

  }


  cout << "Total payload bytes: " << total_payload_bytes << endl;
  cout << "Total bytes including packet headers: " << total_bytes << endl;
  cout << "Total cycles: " << total_cycles << endl;

  cout << "Simulation: execution time is " << (double)total_cycles/(double)total_payload_bytes << " cycles/byte" << endl;


  return 0;
}
