/*------------------------------------------------------------------------
 * File:	eps_elimination.cc
 *
 * Author:	Liu Yang
 * Date:	Jul 17, 2009
 *
 * Perform epsilon elimination
 *------------------------------------------------------------------------
 * $Log: eps_elimination.cc,v $
 * Revision 1.3  2010/09/27 14:21:06  lyangru
 * final synchronization
 *
 * Revision 1.1  2009/09/02 01:57:00  lyangru
 * startup
 *
 * */

#include <iostream>
#include <map>
#include <set>
#include <vector>
#include <string>
#include <cstdlib>
#include "nfa-multimap.h"


int main(int argc, char** argv) {

  multimap_nfa *mynfa;
  int start, end;

  if (argc !=3) {
    cerr << "Usage: %s <NFA file name> <output file name>" << endl;
    exit(1);
  }

  mynfa = new multimap_nfa(argv[1], false);

  /* do epsilon elimination for NFA */
  start = cputime();  
  //mynfa->epsilon_elimination(); /* the oldest method */
  //mynfa->epsilon_elimination_improved(); /* better that the oldest */
  mynfa->epsilon_elimination_im3(); /* the most efficient method */
  end = cputime();
  mynfa->out_to_file(argv[2]);
  cout << "Time for epsilon elimination " << (double) (end - start)/1000 << "seconds" << endl;

  return 0;
}
