/*-----------------------------------------------------------------------------
 * dprintf.c
 *   dprintf is a debugging wrapper for printf
 *
 * Author:  Randy Smith
 * Date:    24 August 2006
 *
 *
 *
 *    Copyright 2006,2007 Randy Smith, smithr@cs.wisc.edu
 *
 *    This file contains unpublished confidential proprietary
 *    work of Randy Smith, Department of Computer Sciences,
 *    University of Wisconsin--Madison.  No use of any sort, including
 *    execution, modification, copying, storage, distribution, or reverse
 *    engineering is permitted without the express written consent of
 *    Randy Smith.
 *
 *
 *
 * TODO:
 *-----------------------------------------------------------------------------
 * History:
 * $Log: dprintf.c,v $
 * Revision 1.1  2009/06/09 18:51:21  vinodg
 * *** empty log message ***
 *
 * Revision 1.2  2008/02/13 20:33:10  smithr
 * *** empty log message ***
 *
 * Revision 1.1  2007/08/07 18:00:53  smithr
 * initial check in to CVS
 *
 * Revision 1.3  2006/09/13 21:46:40  smithr
 * Added a richer dprintf interface; updated all calls to dprintf.
 *
 * Revision 1.2  2006/08/31 20:05:12  smithr
 * Machines can be successfully combined and applied to supplied data.
 *
 * Revision 1.1  2006/08/25 16:43:09  smithr
 * Honest-to-goodness implementation of actions.  Currently, we can handle
 * bitmaps, counters, offsets, and generic "fire alert" actions.  We
 * cannot yet nest actions.  That is next.
 *
 *
 *---------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include "dprintf.h"

int g_debug = 1;
static unsigned long interested = 0;


/*-----------------------------------------------------------------------------
 * diag_clear
 *   Removes all facilities.
 *---------------------------------------------------------------------------*/
void diag_clear(void) 
{
   diag_rem_interest(DIAG_ALL);
}


/*-----------------------------------------------------------------------------
 * diag_add_interest
 *   Adds a facility to the set of topics that we are interested in.
 *---------------------------------------------------------------------------*/
void diag_add_interest(unsigned long intr)
{
   interested |= intr;
}


/*-----------------------------------------------------------------------------
 * diag_rem_interest
 *   Removes a facility from the set of topics that we are interested in.
 *---------------------------------------------------------------------------*/
void diag_rem_interest(unsigned long intr)
{
   interested &= ~intr;
}


void dprintf_(FILE *out, unsigned long facility, const char *msg, ...)
{
   va_list arglist;
   
   if (g_debug && (interested & facility))
   {   
      va_start(arglist, msg);
      vfprintf(out, msg, arglist);
      va_end(arglist);
   }
}
