/*-----------------------------------------------------------------------------
 * dprintf.h
 *   dprintf is a debugging wrapper for printf
 *
 * Author:  Randy Smith
 * Date:    24 August 2006
 *
 *
 *
 *    Copyright 2006,2007 Randy Smith, smithr@cs.wisc.edu
 *
 *    This file contains unpublished confidential proprietary
 *    work of Randy Smith, Department of Computer Sciences,
 *    University of Wisconsin--Madison.  No use of any sort, including
 *    execution, modification, copying, storage, distribution, or reverse
 *    engineering is permitted without the express written consent of
 *    Randy Smith.
 *
 *
 * TODO:
 *-----------------------------------------------------------------------------
 * History:
 * $Log: dprintf.h,v $
 * Revision 1.1  2009/06/09 18:51:21  vinodg
 * *** empty log message ***
 *
 * Revision 1.2  2008/02/13 20:33:10  smithr
 * *** empty log message ***
 *
 * Revision 1.1  2007/08/07 18:00:52  smithr
 * initial check in to CVS
 *
 * Revision 1.5  2007/03/29 13:38:35  smithr
 * Added regression statistics code, which was an attempt to indirectly
 * measure the cost of instructions, etc.
 *
 * Revision 1.4  2006/12/22 00:05:18  smithr
 * Many changes to many files, mostly revolving around:
 * (1) addition of compressed edges to reduce memory cost.
 * (2) addition of returns to get detailed memory requirements.
 *
 * Revision 1.3  2006/09/29 23:01:04  smithr
 * make_equivalent was actually broken in that it was not producing
 * equivalence classes.  This has been fixed, and check_equivalent has
 * been added to verify that equivalence classes are actually being
 * produced.
 *
 * Revision 1.2  2006/09/13 21:46:40  smithr
 * Added a richer dprintf interface; updated all calls to dprintf.
 *
 * Revision 1.1  2006/08/25 16:43:10  smithr
 * Honest-to-goodness implementation of actions.  Currently, we can handle
 * bitmaps, counters, offsets, and generic "fire alert" actions.  We
 * cannot yet nest actions.  That is next.
 *
 *
 *---------------------------------------------------------------------------*/
#ifndef DPRINTF_H
#define DPRINTF_H

#ifdef FAST_INSPECTION_TESTS
#define dprintf(out, facility, args...)
#else
#define dprintf(out, facility, args...) dprintf_(out, facility, ##args);
#endif

#define DIAG_NONE    0x00000000
#define DIAG_PARSER  0x00000001
#define DIAG_APPLY   0x00000002
#define DIAG_CMIN    0x00000004
#define DIAG_HUMIN   0x00000008
#define DIAG_REGRESS 0x00000010
#define DIAG_ALL     0xFFFFFFFF

void diag_clear(void);
void diag_add_interest(unsigned long);
void diag_rem_interest(unsigned long);

void dprintf_(FILE *out, unsigned long facility, const char *msg, ...);

#endif


