/*-----------------------------------------------------------------------------
 * errmsg.cc
 *   Error reporting routines for the lexer/parser
 *
 * Author:  Randy Smith
 * Date:    11 July 2006
 *
 *
 *
 *    Copyright 2006,2007 Randy Smith, smithr@cs.wisc.edu
 *
 *    This file contains unpublished confidential proprietary
 *    work of Randy Smith, Department of Computer Sciences,
 *    University of Wisconsin--Madison.  No use of any sort, including
 *    execution, modification, copying, storage, distribution, or reverse
 *    engineering is permitted without the express written consent of
 *    Randy Smith.
 *
 *-----------------------------------------------------------------------------
 * History:
 * $Log: errmsg.cc,v $
 * Revision 1.1  2009/06/09 18:51:21  vinodg
 * *** empty log message ***
 *
 * Revision 1.2  2008/02/13 20:33:10  smithr
 * *** empty log message ***
 *
 * Revision 1.1  2007/08/07 18:00:50  smithr
 * initial check in to CVS
 *
 * Revision 1.2  2006/08/10 18:35:33  smithr
 * Several additions and bug fixes, including:
 * (1) user defined char classes implemented.
 * (2) escape sequences fully handled
 * (3) memory management addressed (destructors free mem as necessary)
 * (4) many other miscellaneous bugs, etc.
 *
 * Revision 1.1  2006/08/10 14:22:59  smithr
 * Initial check-in to CVS
 *
 * Revision 1.2  2006/07/15 04:54:01  smithr
 * Extended the grammar to accept negated symbols lists and concatenated
 * lists of symbols, e.g. "ACE" can be used as an alternative to 'A','C','E'
 *
 * Revision 1.1  2006/07/12 18:54:06  smithr
 * Combination of multiple moore machines is functional.
 *
 *---------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>

void warnf(unsigned int lineno, const char *message,...)
{
   va_list arglist;

   fprintf(stdout, "%u: WARNING, ", lineno);

   va_start(arglist, message);
   vfprintf(stdout, message, arglist);
   fprintf(stdout, "\n");
   va_end(arglist);
}

void errf(unsigned int lineno, const char *message,...)
{
   va_list arglist;

   fprintf(stdout, "%u: ERROR, ", lineno);

   va_start(arglist, message);
   vfprintf(stdout, message, arglist);
   va_end(arglist);
   fprintf(stdout, "\n");
   exit(-1);
}
