/*-----------------------------------------------------------------------------
 * nfa_combination.cc
 * Program to combine NFA's from Snort signatures 
 * (suit other sig set as well).
 *
 * Author:  Liu Yang
 * Date:    July 8, 2009
 *
 *-----------------------------------------------------------------------------
 * $Log: nfa_combination.cc,v $
 * Revision 1.6  2010/09/27 14:48:31  lyangru
 * final synchronization
 *
 *
 *---------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <iostream>
#include <sys/time.h>
#include <sys/resource.h>
#include "nodes.h"
#include "re.h"
#include "nfa.h"
#include "minimize.h"
#include "globals.h"

#define DEBUG

/* defined in combine_alg.cc */
nfa_t* combine(nfa_t* NFA1, nfa_t* NFA2);


regex_tree_t *RE = NULL;
nfa_t *NFA = NULL;
nfa_t *DFA = NULL;

int cputime();

/*-----------------------------------------------------------------------------
 * main
 *---------------------------------------------------------------------------*/
int main(int argc, char *argv[])
{
   FILE *f;
   char buf[4096];
   char *p;
   int line = 1;
   nfa_t *tmp_nfa, *com_nfa;
   nfa_t *tmp_dfa, *com_dfa;
   int i = 0;
   unsigned long start = 0, end = 0;

   if (argc != 3) {
      printf("usage: %s <regex file name> <output file name>\n", argv[0]);
      return -1;
   }

   if ( (f=fopen(argv[1], "r")) == NULL) {
      printf("failed to open file %s\n", argv[1]);
      exit(0);
   }

   start = cputime();

   p = fgets(buf, 4096, f);
   p[strlen(p)-1] = '\0';  /* get rid of trailing \n */
   NFA = re_to_nfa(buf, strlen(buf), line, line++);
   tmp_nfa = NFA;

   p = fgets(buf, 4096, f);
   while (p != NULL) {
#ifdef DEBUG
      i++;
//      if ((i % 10) == 0)
        printf("The %dth regular expression ...\n", i);
#endif      
      p[strlen(p)-1] = '\0';  /* get rid of trailing \n */
      NFA = re_to_nfa(buf, strlen(buf), line, line++);
      /* NFA combination | (OR) */
      com_nfa = do_alternation_acc(tmp_nfa, NFA);
      delete tmp_nfa;
      tmp_nfa = com_nfa;

      delete NFA;
      memset(buf, 0, 4096);
      p = fgets(buf, 4096, f);
   }

   end = cputime();
   com_nfa->bdd_output(argv[2], 42);

   fclose(f);

   cout << "Time used for NFA combination: " << (double)(end - start) / (double)1000 << " seconds" << endl;

   return 1;
}

int cputime()
{
  struct rusage rus;

  getrusage (RUSAGE_SELF, &rus);
  return rus.ru_utime.tv_sec * 1000 + rus.ru_utime.tv_usec / 1000;
}


