/*-----------------------------------------------------------------------------
 *parse_utils.h
 * Miscellaneous utilities to assist with parsing.
 *
 * Author:  Randy Smith
 * Date:    10 August 2006
 *
 *
 *    Copyright 2006,2007 Randy Smith, smithr@cs.wisc.edu
 *
 *    This file contains unpublished confidential proprietary
 *    work of Randy Smith, Department of Computer Sciences,
 *    University of Wisconsin--Madison.  No use of any sort, including
 *    execution, modification, copying, storage, distribution, or reverse
 *    engineering is permitted without the express written consent of
 *    Randy Smith.
 *
 *-----------------------------------------------------------------------------
 * History:
 * $Log: parse_utils.h,v $
 * Revision 1.1  2009/06/09 18:51:22  vinodg
 * *** empty log message ***
 *
 * Revision 1.2  2008/02/13 20:33:10  smithr
 * *** empty log message ***
 *
 * Revision 1.1  2007/08/07 18:00:53  smithr
 * initial check in to CVS
 *
 * Revision 1.1  2006/08/11 14:55:30  smithr
 * Added parse_utils, which provides a mechanism for parsing regexes stored
 * in a string rather than just stored in a file.
 *
 *
 *
 *---------------------------------------------------------------------------*/
#ifndef PARSE_UTILS_H
#define PARSE_UTILS_H

#include "nodes.h"

/*-----------------------------------------------------------------------------
 * regex_from_mem
 *   parses a regex stored in memory.  You probably want to use parse_regex()
 *   (above) instead of this function.
 *   
 *   data - buffer holding the regex to parse
 *   len  - length of string to be parsed
 *   line - "line number" of buffer, used as an identifier
 *---------------------------------------------------------------------------*/
disjunction *regex_from_mem(char *data, int len, int line=1);


/*-----------------------------------------------------------------------------
 * regex_from_file
 *   parses a regex stored in a file.
 *
 *---------------------------------------------------------------------------*/
disjunction *regex_from_file(FILE *fp);
      

#endif
