/*-----------------------------------------------------------------------------
 * File:    re.cc
 *
 *
 * Author:  Randy Smith
 * Date:    18 May 2007
 *
 *
 *    Copyright 2006,2007 Randy Smith, smithr@cs.wisc.edu
 *
 *    This file contains unpublished confidential proprietary
 *    work of Randy Smith, Department of Computer Sciences,
 *    University of Wisconsin--Madison.  No use of any sort, including
 *    execution, modification, copying, storage, distribution, or reverse
 *    engineering is permitted without the express written consent of
 *    Randy Smith.
 *
 *-----------------------------------------------------------------------------
 * History
 * $Log: re.cc,v $
 * Revision 1.1  2009/06/09 18:51:22  vinodg
 * *** empty log message ***
 *
 * Revision 1.3  2008/04/17 21:12:53  smithr
 * Added a delete to avoid a memory leak.
 *
 * Revision 1.2  2008/02/13 20:33:10  smithr
 * *** empty log message ***
 *
 * Revision 1.1  2007/08/07 18:00:51  smithr
 * initial check in to CVS
 *
 *
 *---------------------------------------------------------------------------*/
#include <stdio.h>
#include "re.h"
#include "globals.h"

nfa_t *disjunct_to_nfa(disjunction *re);

/*-----------------------------------------------------------------------------
 * re_to_nfa
 *   This is the intended public interface for converting from a regular 
 *   expression to an nfa (with epsilon transitions).  This presumes
 *---------------------------------------------------------------------------*/
nfa_t* re_to_nfa(char *data, int len, int line, unsigned int id)
{
   regex_tree_t* re;
   nfa_t *nfa;

   /* parse the regex */
   re = parse_regex(data, len, line);
   nfa = re_tree_to_nfa(re, id);

   delete re; /* don't need the parse tree anymore */

   return nfa;
}


/*-----------------------------------------------------------------------------
 * parse_regex
 *   This is the intended public interface for parsing a regular expression
 *   into a tree.  This wraps regex_from_mem while also applying any modifiers
 *---------------------------------------------------------------------------*/
regex_tree_t* parse_regex(char *data, int len, int line)
{
   disjunction *re;

   re = regex_from_mem(data, len, line);
   if (g_flags.implicit_star)
   {
      fprintf(stdout, "Adding implicit star\n");
      re->add_star();
   }

   return re;
}




/*-----------------------------------------------------------------------------
 * re_tree_to_nfa
 *---------------------------------------------------------------------------*/
nfa_t *re_tree_to_nfa(regex_tree_t *re, unsigned int id)
{
   nfa_t *n;
   n = disjunct_to_nfa(re);
   n->set_id(id);
   n->set_accepting_states(id);
   return n;
}
