/*-----------------------------------------------------------------------------
 * File:    re.h
 *
 *
 * Author:  Randy Smith
 * Date:    18 May 2007
 *
 *
 *    Copyright 2006,2007 Randy Smith, smithr@cs.wisc.edu
 *
 *    This file contains unpublished confidential proprietary
 *    work of Randy Smith, Department of Computer Sciences,
 *    University of Wisconsin--Madison.  No use of any sort, including
 *    execution, modification, copying, storage, distribution, or reverse
 *    engineering is permitted without the express written consent of
 *    Randy Smith.
 *
 *-----------------------------------------------------------------------------
 * History
 * $Log: re.h,v $
 * Revision 1.1  2009/06/09 18:51:22  vinodg
 * *** empty log message ***
 *
 * Revision 1.2  2008/02/13 20:33:10  smithr
 * *** empty log message ***
 *
 * Revision 1.1  2007/08/07 18:00:53  smithr
 * initial check in to CVS
 *
 *
 *---------------------------------------------------------------------------*/
#ifndef RE_H
#define RE_H

#include "nodes.h"
#include "nfa.h"
#include "parse_utils.h"


/*-----------------------------------------------------------------------------
 * re_to_nfa
 *   This is the intended public interface for converting from a regular 
 *   expression to an nfa (with epsilon transitions).  This does the whole
 *   ball of wax from the parsing perspective.  Once an nfa is created,
 *   member functions may be employed to eliminate epsilons, determinize,
 *   etc.
 *
 *   Code implemented in nfa.cc
 *---------------------------------------------------------------------------*/
nfa_t* re_to_nfa(char *data, int len, int line, unsigned int id);


/*-----------------------------------------------------------------------------
 * parse_regex
 *   This is the intended public interface for parsing a regular expression
 *   into a tree.  It presumes the regex is read from memory, and it performs
 *   modifier actions as necessary.
 *
 *   Call this function only if you want intermediate results (a parse tree)
 *   rather than an NFA.
 *
 *   Code is in parse_utils.cc
 *---------------------------------------------------------------------------*/
regex_tree_t* parse_regex(char *data, int len, int line);


/*-----------------------------------------------------------------------------
 * re_tree_to_nfa
 *   This computes an nfa from a regex parse tree.
 * 
 *    Call this function only if you are manipulating or working with parts
 *    of the RE->NFA process.  Typically, a call to re_to_nfa() will complete
 *    the entire process.
 *
 * code implemented in nfa.cc
 *---------------------------------------------------------------------------*/
nfa_t *re_tree_to_nfa(regex_tree_t *re, unsigned int id);



#endif 
