/*-----------------------------------------------------------------------------
 *re2dfa.cc
 * converts a regular expression to a minimized dfa.
 *
 * Author:  Randy Smith
 * Date:    19 May 2007
 *
 *
 *    Copyright 2006,2007 Randy Smith, smithr@cs.wisc.edu
 *
 *    This file contains unpublished confidential proprietary
 *    work of Randy Smith, Department of Computer Sciences,
 *    University of Wisconsin--Madison.  No use of any sort, including
 *    execution, modification, copying, storage, distribution, or reverse
 *    engineering is permitted without the express written consent of
 *    Randy Smith.
 *
 *-----------------------------------------------------------------------------
 * History:
 * $Log: re2dfa_nomin.cc,v $
 * Revision 1.1  2009/06/09 18:51:22  vinodg
 * *** empty log message ***
 *
 * Revision 1.2  2008/02/13 20:33:10  smithr
 * *** empty log message ***
 *
 * Revision 1.1  2007/08/07 18:00:52  smithr
 * initial check in to CVS
 *
 *
 *---------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "nodes.h"
#include "re.h"
#include "nfa.h"
#include "minimize.h"
#include "globals.h"

void usage_and_die(const char *msg);
nfa_t *dfa_min1();



regex_tree_t *RE = NULL;
nfa_t *NFA = NULL;
nfa_t *DFA = NULL;

/*-----------------------------------------------------------------------------
 * main
 *---------------------------------------------------------------------------*/
int main(int argc, char *argv[])
{
   char buf[16384];
   unsigned int id;
   string outfile;

   if (argc != 4)
   {
      usage_and_die("Missing input data.");
   }

   memset(buf, '\0', 16384);
   strncpy(buf, argv[1], 16383);
   id = atoi(argv[2]);
   printf("regex is: %s\n", buf);

   NFA = re_to_nfa(buf, strlen(buf), 1, id);
   DFA = NFA->make_dfa();
   //nfa_minimize(DFA);

   DFA->xfa_output(argv[3], id);
   return 1;
}


/*-----------------------------------------------------------------------------
 * usage_and_die
 *---------------------------------------------------------------------------*/
void usage_and_die(const char *msg)
{
   fprintf(stderr, "error: %s\n", msg);
   fprintf(stderr, "\nusage: re2dfa <regex> <id> <outfilename>\n");

   fprintf(stderr, "\n"
	   "re2dfa builds a minimized DFA from a regular expression.\n");

   fprintf(stderr, "\n"
   "An example input file is the following:\n"
   "\n"
   "       /[\\d./*]{5,}\\wx+-y|^(\\d:\\d:\\d\\/)/   \n"
   "       /([^\\n]*?<){55}/  \n");

   fprintf(stderr, "\n\n\n");
   exit(0);
}

