#!/usr/bin/perl -w
use strict;

my $globoutput = "temp/globoutput.txt";
my $globnames = "temp/globgdbscript.txt";
my $origfile = "globvars.txt";
my $outfile = "globvars_fixed.txt";
my $errorfile = "temp/errors.txt";

open (IN, "<$globoutput") or die "Couldn't open input file: $!";
open (ERR, ">$errorfile") or die "Couldn't open output file: $!";

my $count = 0;
my $count2 = 0;

while (my $sLine = <IN>) {

	if(substr($sLine,0,9) eq "No symbol"){

		my @values = split(" ",$sLine);
		my $name = substr($values[2],1,(length $values[2])-2);
		#print STDOUT "error" . " " . $name . "\n";
		$count++;

		open (INNAMES, "<$globnames") or die "Couldn't open input file: $!";

		while(my $nLine = <INNAMES>){
			if("ptype $name\n" eq $nLine){
				print ERR "$nLine";
				last;
			}
		}
		close(INNAMES);
	}
}
close(IN);
close(ERR);

open (INORIG, "<$origfile") or die "Couldn't open input file: $!";
open (OUT, ">$outfile") or die "Couldn't open output file: $!";

while (my $sLine = <INORIG>) {

	my @values = split(" ",$sLine);
	my $globname = $values[1];
	$globname = substr($globname,1,(length $globname)-2);
	
	my $bool = 0;
	open (ERR, "<$errorfile") or die "Couldn't open output file: $!";
	while(my $eLine = <ERR>){
		if("ptype $globname\n" eq $eLine){
			$bool = 1;
			last;
		}
	}
	close(ERR);
	
	if($bool == 0){
		print OUT $sLine;
		$count2++;
	}
}

print STDOUT  $count . "\n";
print STDOUT  $count2 . "\n";

close(ERR);
close(OUT);