/* Program reads the input/typedefs.gen file
   It removes the "field", "@" and "|" characters and creates a
   typedefs.gen.h file to be included by the generator */

#include <stdio.h>
#include <assert.h>
#include <string.h>

#define MAX_LINE_INPUT_SIZE 500
#define LEFT_FIELD_DELIMITER  '@'
#define RIGHT_FIELD_DELIMITER '|'
#define MAX_FIELD_WIDTH 200
#define MISSING_FIELD_NAME "___missing_field_name"

char * get_field_info(char * buffer, short field_num);
char * ltrim(char * str);
char * rtrim(char * str);
char * trim(char * str);

int main()
{
	FILE * fd_in;	
	FILE * fd_out;	
	char buffer[MAX_LINE_INPUT_SIZE];
	char type_indicator =0; // enum set to 0, struct/unions set to 1
	short num_passes = 2, pass;

	fd_in = fopen("../input/typedefs.txt", "r");
	fd_out = fopen("../input/typedefs.txt.h", "w");

	if(fd_in == NULL)
	{
		printf("Could not open input file\n");
		exit(-1);
	}

	for(pass=0; pass<num_passes; pass++)
	{
		//In pass 0, print only typedefs, in pass 1 print strcts, unions,enums
		short missing_counter =0;

		fgets(buffer,MAX_LINE_INPUT_SIZE,fd_in);	
		while(!feof(fd_in))
		{
			char new_buffer[MAX_LINE_INPUT_SIZE];
			int i=0;
			int j=0;

			char * name;
			char * type;
			char * literal;
			char * subtype;
			char strsubtype[MAX_LINE_INPUT_SIZE];
			char missing_name[MAX_FIELD_WIDTH];

			literal = get_field_info(buffer,1);
			type= get_field_info(buffer,2);
			strsubtype[0]='\0';

			if(type != NULL)
			{
				subtype = strstr(type, "[");
				if(subtype != NULL)
				{
					strcpy(strsubtype, subtype);
					subtype[0]='\0';
				}
			} 

			name = get_field_info(buffer,3);

			if((strstr(buffer,"enum") != NULL) && (strstr(buffer,"{") != NULL))
			{
				type_indicator = 0;
				missing_counter = 0;
			}
			else if(((strstr(buffer,"struct") != NULL) || (strstr(buffer,"union") != NULL)) && (strstr(buffer,"{") != NULL))
			{
				type_indicator = 1;
				missing_counter = 0;
			}


			if(literal != NULL)
			{
				if(strcmp(literal,"field") == 0)
				{
					if(strcmp(name,MISSING_FIELD_NAME) == 0)
					{
						char strmiscounter[MAX_FIELD_WIDTH];

						sprintf(strmiscounter,"%d",missing_counter++);
						strcpy(missing_name, name);	
						strcat(missing_name, strmiscounter);
						name = missing_name;
					}
					if(pass == 1)
					{
						if(strstr(buffer,"(*)(") != NULL)
						{
							//Function pointer
							char new_type[MAX_LINE_INPUT_SIZE];
							short i, j;

							i=0; j=0;
							while(i<strlen(type))
							{
								if((type[i] == '(') && (type[i+1] == '*'))
								{
									short k;
									new_type[j++] = type[i++];
									new_type[j++] = type[i++];

									k=0;
									while(k < strlen(name))
									{
										new_type[j++] = name[k++];
									}

									new_type[j] = type[i++];
								}
								else
								{
									new_type[j] = type[i];
									i++;
								}
								j++;
							}
							new_type[j]='\0';
							fprintf(fd_out,"%s; //%s\n", new_type,name);
						}
						else
						{

							if(strlen(strsubtype) > 0)
							{
								if(type_indicator == 1)
								{
									fprintf(fd_out, "\t%s %s", type, name); 
									fprintf(fd_out, " %s; //%s\n", strsubtype, name); 
								}
								else
								{
									fprintf(fd_out, "\t%s=%s", type, name); 
									fprintf(fd_out, " %s,\n", strsubtype); 
								}
							}
							else
							{
								if(type_indicator == 1)
								{
									fprintf(fd_out, "\t%s %s", type, name); 
									fprintf(fd_out, "; //%s\n", name); 
								}
								else
								{
									fprintf(fd_out, "\t%s=%s", type, name); 
									fprintf(fd_out, ",\n"); 
								}
							}
						}
					}
				}
				else if(strcmp(literal,"typedef") == 0)
				{
					if(pass == 0)
					{
						char * tmp;

						tmp = name;
						name = type;
						type = tmp;
						//printf("buffer: %s\n",buffer);
						if(strstr(buffer,"(*)(") != NULL)
						{
							//Function pointer
							char new_type[MAX_LINE_INPUT_SIZE];
							short i, j;

							i=0; j=0;
							while(i<strlen(type))
							{
								if((type[i] == '(') && (type[i+1] == '*'))
								{
									short k;
									new_type[j++] = type[i++];
									new_type[j++] = type[i++];

									k=0;
									while(k < strlen(name))
									{
										new_type[j++] = name[k++];
									}

									new_type[j] = type[i++];
								}
								else
								{
									new_type[j] = type[i];
									i++;
								}
								j++;
							}
							new_type[j]='\0';
							//fprintf(fd_out,"typedef %s %s;\n", new_type, name);
							fprintf(fd_out,"typedef %s;\n", new_type);
						}
						// JEFF change to check for attribute
						else if((strstr(buffer,"(") != NULL) && (strstr(buffer,")") != NULL) && (strstr(buffer," __attribute__") == NULL))
						{
							//typedef function
							char tmp[MAX_FIELD_WIDTH], new_name[MAX_FIELD_WIDTH];
							char * ptr;

							strcpy(tmp,type);
							ptr = strstr(type, "(");
							if(ptr == NULL)
								printf("ptr null %s\n",type);
							ptr[0]='\0';	

							strcpy(new_name, type);	
							strcat(new_name, name);

							ptr = strstr(tmp,"(");
							strcat(new_name, ptr);

							fprintf(fd_out,"%s %s;\n",literal, new_name);
						}
						else
						{
							char * subtype;
							char strsubtype[MAX_FIELD_WIDTH];

							strsubtype[0]='\0';

							subtype = strstr(type, "[");
							if(subtype != NULL)
							{
								strcpy(strsubtype, subtype);
								subtype[0]='\0';
							}

							if(strsubtype != NULL)
							{
								fprintf(fd_out,"%s %s %s%s;\n",literal, type, name, strsubtype);
							}
							else
							{
								fprintf(fd_out,"%s %s %s;\n",literal, type, name);
							}
						}
					}
				}
			}
			else
			{
					if(pass == 1)
					{
							fprintf(fd_out, "%s", buffer); 
					}
			}

			fgets(buffer,MAX_LINE_INPUT_SIZE,fd_in);	
		}

		if(pass == 0)
		{
				//Seek to the beginning of file
				fseek(fd_in,0, SEEK_SET);
		}	
	}

	fclose(fd_in);	
	fclose(fd_out);	
	
	return 0;
}

char * get_field_info(char * buffer, short field_num)
{
    char l_delimiter =LEFT_FIELD_DELIMITER;
    char r_delimiter =RIGHT_FIELD_DELIMITER;
    short field_counter =0;
    char * ret_buf;
    short start_copying = 0, copied =0;
    int j=0;
    int i;
                                                                                                                                               
    ret_buf = (char *)malloc(MAX_LINE_INPUT_SIZE);
    for(i=0; i< strlen(buffer); i++)
    {
        if(buffer[i] == l_delimiter)
        {
            field_counter++;
            if(field_counter == field_num) //This is the field to return
            {
                start_copying = 1;
            }
        }
        else if(buffer[i] == r_delimiter)
        {
            if(field_counter == field_num)
            {
                assert(start_copying == 1);
                *(ret_buf + j) = '\0';
                copied = 1;
                break;
            }
        }
        else
        {
            if(start_copying == 1)
            {
                *(char *)(ret_buf + j) = buffer[i];
                                                                                                                                               
                j++;
            }
        }
    }
    if(copied == 1)
        return(ret_buf);
    else
        return(NULL);
}

char * rtrim(char * str)
{
    int i;
                                                                         
                                                                         
    for(i = (strlen(str) - 1); i >= 0; i--)
    {
        char c = *(char *)(str + i);
                                                                         
                                                                         
        if((c == ' ') || (c == '\0') || (c == '\n'))
        {
            *(char *)(str + i) = '\0';
        }
        else
        {
            break;
        }
    }
    return(str);
}
                                                                         
                                                                         
char * ltrim(char * str)
{
    int i;
                                                                         
                                                                         
    for(i =0; i < strlen(str); i++)
    {
        char c = *(char *)(str + i);
                                                                         
                                                                         
        if((c == ' ') || (c == '\0'))
        {
            *(char *)(str + i) = '\0';
        }
        else
        {
            break;
        }
    }
    return(str);
}

char * trim(char * str)
{
    return(rtrim(ltrim(str)));
}
