#include <stdio.h>
#include <iostream>
#include <string>
#include <map>
#include <vector>
#include <stdlib.h>
#include <assert.h>
#include <string.h>
using namespace std;

/* Reads from file typedefs.gen and file offsets.gen
   and creates an in-memory map of definitions for
   fast access 
*/

#define MAX_LINE_INPUT_SIZE 300
#define LEFT_FIELD_DELIMITER '@'
#define RIGHT_FIELD_DELIMITER '|'
#define ATTRIBUTE_STRING "__attribute__(("
#define ATTRIBUTE_STRING_LEN 15
#define ATTR_STRING "} __attribute__(("


typedef struct
{
    string name;
    string type;
    int offset;
    int size;
} field_t;

static map<string,string> typedefs;
typedef vector<field_t> definition_t;
map<string,definition_t> def_map;
vector<string> def_order;


void build_typedef_index();
bool is_typedef(const char * str);
const char * resolve_typedef(const char * str);
char * get_field_info(char * buffer, short field_num);
char * trim(char * str);
char * ltrim(char * str);
char * rtrim(char * str);
int build_definition_map();
void print_definition_map();
void create_new_offsets();
bool function_ptr(char * str);
int get_array_index(char * ds_type);
void handle_fields(FILE * fdout, string def, int base_offset, string parent_name);


int main()
{
	build_definition_map();
	print_definition_map();

	create_new_offsets();

	return 0;
}

void create_new_offsets()
{
	//Keep the order of the output file same as offsets.gen
	//This order is available in vector def_order
	vector<string>::iterator viter = def_order.begin();
	FILE * fdout;

	fdout = fopen("../input/offsets.gen.fixed","w");
	if(fdout == NULL)
	{
		printf("Cannot open file ../input/offsets.gen.fixed\n");
		exit(-1);
	}

	while(viter != def_order.end())
	{
		string def = *viter;	
		
		fprintf(fdout,"%s\n",def.c_str());

	cout << "Finding def main [" << def << "]" <<endl;
		handle_fields(fdout,def, 0,"");

		viter++;
	}

	fclose(fdout);	
}

void handle_fields(FILE * fdout, string def, int base_offset, string parent_name)
{
	definition_t t;
	vector<field_t>::iterator fiter;
	map<string,definition_t>::iterator iter = def_map.find(def.c_str());
                                                                                                                                               
    if(iter == def_map.end())
    {
    	fprintf(fdout,"Could not find definition. %s\n",def.c_str());
    }
    else
    {
		t = iter->second; 
		fiter = t.begin();
	}

	while(fiter != t.end())
	{
		//Iterate through the fields
		field_t fld = *fiter;
		if(!function_ptr((char *)fld.type.c_str()))
    	{
			if(strstr(fld.type.c_str(),ATTRIBUTE_STRING) != NULL)
			{
				char mod_fld[MAX_LINE_INPUT_SIZE];
				char * ptr;

				strcpy(mod_fld, fld.type.c_str());
				ptr = strstr(mod_fld,ATTRIBUTE_STRING);

				ptr[0]='\0';
				cout << "Original fld type ="<< fld.type << endl;
				fld.type = trim(mod_fld);
				cout << "Modified fld type ="<< mod_fld << endl;
			}
   			if((strstr(fld.type.c_str(),"struct") != NULL) && (strstr(fld.type.c_str(),"*") == NULL))
         	{
             	//This is either a struct or a struct array
             	char type[MAX_LINE_INPUT_SIZE];
				char struct_name[MAX_LINE_INPUT_SIZE];
				string strstruct_name;
				char * ptr;

				strcpy(type,fld.type.c_str());
				ptr = strtok(type, " ");
				strcpy(struct_name, ptr);
				ptr = strtok(NULL, " ");
				strcat(struct_name, " ");
				strcat(struct_name, ptr);
				strstruct_name = struct_name;

				int index = 0;

				if((strstr((char *)fld.type.c_str(),"[") != NULL) && (strstr((char *)fld.type.c_str(),"]") != NULL))
				{
					index =get_array_index((char *)fld.type.c_str());	
				}
				//Have to expand the struct
				if(index > 0)
				{
					int struct_size = fld.size / index;
					char pname[MAX_LINE_INPUT_SIZE];


					for(int i=0; i< index; i++)
					{
						int new_base_offset = base_offset + fld.offset + (i * struct_size);
						string name;
						sprintf(pname,"%s%d",fld.name.c_str(),i);

						if(parent_name.length() > 0)
						{
							name = parent_name + "___" + pname;
						}
						else
						{
							name = pname;
						}
						handle_fields(fdout,strstruct_name, new_base_offset,name);	
					}
				}
				else
				{
					char pname[MAX_LINE_INPUT_SIZE];
					int new_base_offset = base_offset + fld.offset;
					string name;

					sprintf(pname,"%s%d",fld.name.c_str(),0);
					if(parent_name.length() > 0)
					{
						name = parent_name + "___" + pname;
					}
					else
					{
						name = pname;
					}
					handle_fields(fdout, strstruct_name, new_base_offset, name);
				}
         	}
         	else
         	{
            	//Could be struct pointer
				int offset = base_offset + fld.offset;
				string name;
				if(parent_name.length() > 0)
				{
					name = parent_name + "___" + fld.name;
				}
				else
				{
					name = fld.name;
				}
				fprintf(fdout,"      %s %d %d\n",name.c_str(), offset, fld.size);

			}
    	}
    	else
    	{
			int offset = base_offset + fld.offset;
			string name;
			if(parent_name.length() > 0)
			{
				name = parent_name + "___" + fld.name;
			}
			else
			{
				name = fld.name;
			}
        	fprintf(fdout,"      %s %d %d\n",name.c_str(), offset, fld.size);
    	}
		fiter++;
	}
}

int get_array_index(char * ds_type)
{
    //Get the array indices
    char * start_index, * end_index;
	char str_arr_index[5];
	int arr_index = 0;

	start_index = index(ds_type,'[');
	end_index = index(ds_type, ']');
	
	if((start_index == NULL) || (end_index == NULL))
	{
		return 0;
	}

	int i=0;

	while(start_index < end_index)
	{
		++start_index;
		str_arr_index[i++] = *(char *)start_index;
	}
	str_arr_index[i + 1] ='\0';
	arr_index = atoi(str_arr_index);

	//Check here is array is two dimensional array
	if(strchr(end_index,'[') != NULL)
	{
		//Get the second index
		char str_arr_index2[5];

		i=0;
		start_index = end_index + 1;
		end_index = strchr(start_index,']');

		while(start_index < end_index)
		{
			++start_index;
			str_arr_index2[i++] = *(char *)start_index;
		}
		str_arr_index2[i + 1] ='\0';
		arr_index = arr_index * atoi(str_arr_index2);
	}
	return(arr_index);

}

//JEFF lots of printf
int build_definition_map()
{
	build_typedef_index();

	FILE * fdtypes;
	FILE * fdoff;
	char buffer[MAX_LINE_INPUT_SIZE];
	char obuf[MAX_LINE_INPUT_SIZE];

    fdtypes = fopen("../input/typedefs.txt","r");
    if(fdtypes == NULL)
    {
        printf("Cannot open file ../input/typedefs.txt\n");
        exit(-1);
    }

    fdoff = fopen("../input/offsets.txt","r");
    if(fdoff == NULL)
    {
        printf("Cannot open file ../input/offsets.txt\n");
        exit(-1);
    }

	fgets(buffer,MAX_LINE_INPUT_SIZE,fdtypes);
	fgets(obuf,MAX_LINE_INPUT_SIZE,fdoff);
 	while(!feof(fdtypes))
    {
			//printf("buffer: %s obuf: %s\n", buffer,obuf);
		if((strstr(buffer,"struct") != NULL) || (strstr(buffer,"union") != NULL))
		{
		//	printf("in struct union\n");
			if(strstr(buffer,"{") != NULL)
			{
				//Struct/Union definition encountered
				vector<field_t> vfields;
				char * ptr;
				bool struct_union; //true if struct, false if union

				ptr = strtok(buffer," ");
				string key = ptr;
				ptr = strtok(NULL," ");
				key = key + " " + ptr;
				//printf("trim buffer: %s key str: %s\n",trim(obuf),key.c_str()); 
				//cout << "Key =" << key << endl;
				if(strstr(key.c_str(), "struct") != NULL)
				{
				//	printf("in strstr struct\n");
					def_order.push_back(key);
					struct_union = true;
					//while(strstr(obuf, key.c_str()) == NULL)
					while(strcmp(trim(obuf), key.c_str()) != 0)
					{
						//printf("trim buffer: %s key str: %s\n",trim(obuf),key.c_str()); 
						//printf("while before fgets\n");
						fgets(obuf,MAX_LINE_INPUT_SIZE,fdoff);
						printf("after fgets obuf: %s\n",obuf); 
						//printf("while after fgets\n");
					}
					//printf("out of while\n");
				}
				else
				{
					struct_union = false;
				}

				//printf("before while };\n");
				//Make a vector of all fields
				while((strstr(buffer,"};") == NULL) && (strstr(buffer,ATTR_STRING) == NULL))
				{
					char * decl;
					char * name;
					char * type;
					int offset;
					int size;
					char * ptr;
					field_t fld;
					string strfinaltype;

					fgets(buffer,MAX_LINE_INPUT_SIZE,fdtypes);

					if((strstr(buffer,"};") != NULL) || (strstr(buffer,ATTR_STRING) != NULL))
						break;
					
					decl = get_field_info(buffer,1);
					assert(strcmp(decl,"field") == 0);
					type = get_field_info(buffer,2);
					if(is_typedef(type))
					{
						const char * resolved_type;
						const char * ptr;
						string final_type;

						//cout << "Resolving type " << type << endl;

						ptr = strtok(type," ");
						resolved_type = resolve_typedef(ptr);

						if(strcmp(resolved_type,"") == 0)
						{
							final_type = type;
						}
						else
						{
							final_type = resolved_type;
							ptr = strtok(NULL," ");

							if(ptr != NULL)
							{
								final_type = final_type + ptr;
							}
						}
	
						//cout << "Resolved to " << final_type << endl;
						strfinaltype = final_type;
					}
					else
					{
						strfinaltype = type;
					}
					
					name = get_field_info(buffer,3);
					
					fld.name = name;
					//fld.type = type;	
					fld.type = strfinaltype;	

					if(struct_union == true)
					{
						fgets(obuf,MAX_LINE_INPUT_SIZE,fdoff);
						ptr = strtok(obuf," ");
						printf("obuf=%s\n",obuf);
						printf("buffer: %s name=%s ptr=%s\n",buffer,name,ptr);
						assert(strcmp(name,ptr) == 0);	

						ptr = strtok(NULL," ");
						offset = atoi(ptr);

						ptr = strtok(NULL," ");
						size = atoi(ptr);
						
						fld.size = size;
						fld.offset = offset;
					}
					else
					{
						fld.size = -1;
                        fld.offset = -1;
					}

					vfields.push_back(fld);
				}
				def_map.insert(make_pair(key,vfields));
			}
		}
	//	printf("before fgets\n");
		fgets(buffer,MAX_LINE_INPUT_SIZE,fdtypes);
	//	printf("after fgets\n");
			
	}

	typedefs.clear();

	return 0;
}

void build_typedef_index()
{
	FILE * fdtypes;
	char buffer[MAX_LINE_INPUT_SIZE];
    int arr_index = 0;
                                                                                                                                               
    fdtypes = fopen("../input/typedefs.txt","r");
    if(fdtypes == NULL)
    {
        printf("Cannot open file ../input/typedefs.txt\n");
        exit(-1);
    }

	fgets(buffer,MAX_LINE_INPUT_SIZE,fdtypes);
 	while(!feof(fdtypes))
    {
        char * decl;
        char * name;
        char * type;
                                                                                                                                               
        decl = get_field_info(buffer,1);
        name = get_field_info(buffer,2);
        type = get_field_info(buffer,3);
                                                                                                                                               
                                                                                                                                               
        if((decl != NULL) && (name != NULL) && (type != NULL))
        {
            if(strcmp(decl,"typedef") == 0)
            {
				typedefs.insert(make_pair(name,type));	
            }
        }
        fgets(buffer,MAX_LINE_INPUT_SIZE,fdtypes);
    }
	fclose(fdtypes);
}

bool is_typedef(const char * str)
{
	if(strstr(str,"int") != NULL)
	{
		return false;
	}
	else if(strstr(str,"long") != NULL)
	{
		return false;
	}
	else if(strstr(str,"short") != NULL)
	{
		return false;
	}
	else if(strstr(str,"void") != NULL)
	{
		return false;
	}
	else if(strstr(str,"double") != NULL)
	{
		return false;
	}
	else if(strstr(str,"void") != NULL)
	{
		return false;
	}
	else if(strstr(str,"char") != NULL)
	{
		return false;
	}
	else if(strstr(str,"struct") != NULL)
	{
		return false;
	}
	else if(strstr(str,"union") != NULL)
	{
		return false;
	}
	else if(strstr(str,"enum") != NULL)
	{
		return false;
	}
	else
	{
		return true;
	}
}


/* Returns the resolved type of the given typedef statement, else returns NULL */
const char * resolve_typedef(const char * str)
{
	string s = str;	
	string value = "";

	map<string,string>::iterator iter = typedefs.find(s);
	
	while(iter != typedefs.end())
  	{
		value = iter->second;
		if(is_typedef(value.c_str()))
		{
			iter = typedefs.find(value);
		}
		else
		{
			break;
		}

  	}
	return(value.c_str());	
}

void print_definition_map()
{
	FILE * fdout;

	fdout = fopen("../log/defmap.txt","w");
	
	if(fdout == NULL)
	{
		printf("Cannot create file ../log/defmap.txt\n");
		exit(-1);
	}

	map<string,definition_t>::iterator iter = def_map.begin();

	while(iter!= def_map.end())
	{
		fprintf(fdout,"[%s]\n", (iter->first).c_str());
		definition_t current_def = iter->second;

		for(int j=0; j<current_def.size(); j++)
		{
			field_t current_fld = current_def[j];

			fprintf(fdout,"%s %s %d %d\n", current_fld.name.c_str(), current_fld.type.c_str(), current_fld.offset, current_fld.size);
		}

		iter++;
	}	
	
	fclose(fdout);
}

char * get_field_info(char * buffer, short field_num)
{
    char l_delimiter =LEFT_FIELD_DELIMITER;
    char r_delimiter =RIGHT_FIELD_DELIMITER;
    short field_counter =0;
    char * ret_buf;
    short start_copying = 0, copied =0;
    int j=0;
    int i;
                                                                                                                                               
    ret_buf = (char *)malloc(MAX_LINE_INPUT_SIZE);
    for(i=0; i< strlen(buffer); i++)
    {
        if(buffer[i] == l_delimiter)
        {
            field_counter++;
            if(field_counter == field_num) //This is the field to return
            {
                start_copying = 1;
            }
        }
        else if(buffer[i] == r_delimiter)
        {
            if(field_counter == field_num)
            {
                assert(start_copying == 1);
                *(ret_buf + j) = '\0';
                copied = 1;
                break;
            }
        }
        else
        {
            if(start_copying == 1)
            {
                *(char *)(ret_buf + j) = buffer[i];
                                                                                                                                               
                j++;
            }
        }
    }
    if(copied == 1)
        return(ret_buf);
    else
        return(NULL);
}

char * rtrim(char * str)
{
    int i;
                                                                                                                                               
    for(i = (strlen(str) - 1); i >= 0; i--)
    {
        char c = *(char *)(str + i);
                                                                                                                                               
        if((c == ' ') || (c == '\0') || (c == '\n'))
        {
            *(char *)(str + i) = '\0';
        }
        else
        {
            break;
        }
    }
    return(str);
}
                                                                                                                                               
char * ltrim(char * str)
{
    int i;
                                                                                                                                               
    for(i =0; i < strlen(str); i++)
    {
        char c = *(char *)(str + i);
                                                                                                                                               
        if((c == ' ') || (c == '\0'))
        {
            *(char *)(str + i) = '\0';
        }
        else
        {
            break;
        }
    }
    return(str);
}
                                                                                                                                               
char * trim(char * str)
{
    return(rtrim(ltrim(str)));
}

bool function_ptr(char * str)
{
    char func_def[MAX_LINE_INPUT_SIZE];
    int len;
                                                                                                                                               
    strcpy(func_def, str);
    trim(func_def);
                                                                                                                                               
    len = strlen(func_def);
                                                                                                                                               
    if(strstr(func_def, "(*)") != NULL)
    {
        return(true);
    }
    else if(((strstr(func_def, "(") != NULL) && (strstr(func_def, ")") != NULL))  && (strstr(func_def,ATTRIBUTE_STRING) == NULL))
    {
        return(true);
    }
    return(false);
}


