#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <time.h>
#include <fcntl.h>
#include <math.h>
#include <assert.h>
#include <vector>
#include <queue>
#include <string>
#include <map>
#include <sstream>
#include <string>
#include <iostream>
#include <time.h>
using namespace std;

#define REQUIRED_NUM_SENDS (100)
#define SECURE_HASH_BUFFER_LEN 20
#define OUT_BUFFER_LEN 64
#define KB 1024
#define BUFFER_LEN 5000 // 8K - 8 bytes
#define MB 1048576
#define SLAB_SIZE 4096 //4K is the block size
#define PAGE_SIZE 4096 
#define PAGE_OFFSET 0xc0000000
#define ADDR_RANGE_BEGIN 0x100000
#define FILENAME_SIZE 75 
#define MAX_FIELD_NAME 75 
#define MAX_FIELD_ATTR 150
#define MAX_LINE_INPUT_SIZE 300
#define LEFT_FIELD_DELIMITER '@'
#define RIGHT_FIELD_DELIMITER '|'
#define ATTRIBUTE_STRING "__attribute__(("
#define CONTAINER_ATTRIBUTE "__container__("
#define PATH_SEPARATOR "->"
#define MAX_OBJECTS_TRAVERSED 150000

/* Structure to store the symbol information read from System.Map file */
typedef struct 
{
    char sym_name[MAX_FIELD_NAME];
    char sym_type[MAX_FIELD_ATTR];
    short sym_size;
    bool invariant;
    bool reported;
    bool alert;
    unsigned long long sym_addr;
    unsigned long long sym_id; //This field not yet populated for static symbols
    vector<unsigned char> values; //Store only one value
}symbol_t;

typedef struct
{
    char sym_type[MAX_FIELD_ATTR];
    unsigned long long sym_addr;
    unsigned long long sym_id;
    char sym_attr[MAX_FIELD_ATTR]; //Stores the original type with the attribute string, else empty string
    string pathname;
    string pathtype;
    vector<string> pathaddr;
    int field_offset; //Used in process_linked_list to follow pointers without annotations
    bool root;
}entry_t;

typedef struct
{
    string name; 
    string type; 
    int offset;
    int size;
} field_t;

typedef struct
{
    unsigned long long page_begin;
    unsigned char page_data[SLAB_SIZE];
} page_t;

typedef vector<field_t> definition_t;

typedef enum 
{
    INV_CONSTANT =0 ,
    INV_SET,
    INV_BOUNDS,
    INV_SUBSET,
    INV_LEN,
    INV_UNKNOWN,
}inv_types;

/* Store each invariant type and the invariant string */
typedef struct
{
    string invstr;
    inv_types invtype;
}inv_ent_t;

/* Stores eahc field information to pass to verifier */
typedef struct
{
    string field_name;
    string str_field_value;
    string numeric_field_value; 
    bool isstrfield; //True if field type is string, false if type is numeric
}fld_ent_t;

/* General purpose utility functions */
char * get_field_info(char * buffer, short field_num);
char * rtrim(char * str);
char * ltrim(char * str);
char * trim(char * str);
char * get_time();
