#include <stdio.h>
#include <assert.h>
#include <string.h>
#include <stdlib.h>

//Previously known as static.c
/*  Get symbols information for static memory regions
    to be called get_symbol_info()
    Reads the System.map file and associates type information with each symbol 
	Reads from globvars.txt file to get the type information
	Generates an intermediate file, so process need not be repeated everytime
*/

#define MAX_GLOB_VARS 22000
//#define MAX_GLOB_VARS 13000
// JEFF changed input size from 255 to 300
#define MAX_LINE_INPUT_SIZE 300
#define LEFT_FIELD_DELIMITER '@'
#define RIGHT_FIELD_DELIMITER '|'
#define MAX_FIELD_WIDTH 200
#define MAX_MEMORY_TYPED_LOCATIONS 280000 
//#define MAX_MEMORY_TYPED_LOCATIONS 260000 
//#define MAX_TYPES 500000
#define MAX_TYPES 5000

#define ATTRIBUTE_STRING "__attribute__(("
#define ATTRIBUTE_STRING_LEN 15
#define ATTR_STRING "} __attribute__(("

/* All flags are defined here */
#define REMOVE_TEMPS 1

char * get_field_info(char * buffer, short field_num);
char * rtrim(char * str);
char * ltrim(char * str);
char * trim(char * str);
void create_memory_types();
void type_memory_location(char * sym_addr, char sym_type, char * sym_name,  
						char * ds_type, int ds_size);
void print_memory_types();
void update_static_mem_array(unsigned long ds_addr, char * sym_name, char * sym_type, short ds_size);

unsigned long long handle_char_datatypes(char * ptr, char * sym_addr, char sym_type, char * sym_name,   
                        char * ds_type, int ds_size);
unsigned long long handle_short_datatypes(char * ptr, char * sym_addr, char sym_type, char * sym_name,
                        char * ds_type, int ds_size);
unsigned long long handle_int_datatypes(char * ptr, char * sym_addr, char sym_type, char * sym_name,
                        char * ds_type, int ds_size);
unsigned long long handle_long_datatypes(char * ptr, char * sym_addr, char sym_type, char * sym_name,
                        char * ds_type, int ds_size);
unsigned long long handle_void_datatypes(char * ptr, char * sym_addr, char sym_type, char * sym_name,
                        char * ds_type, int ds_size);
unsigned long long handle_struct_datatypes(char * ptr, char * sym_addr, char sym_type, char * sym_name,
                        char * ds_type, int ds_size);
unsigned long long handle_union_datatypes(char * ptr, char * sym_addr, char sym_type, char * sym_name,
                        char * ds_type, int ds_size);
unsigned long long handle_double_datatypes(char * ptr, char * sym_addr, char sym_type, char * sym_name,
                        char * ds_type, int ds_size);
unsigned long long handle__Bool_datatypes(char * ptr, char * sym_addr, char sym_type, char * sym_name,
                        char * ds_type, int ds_size);

void build_datatypes_index();
long lookup_datatype_index(char * str);
long lookup_gen_datatype_index(char * str);
void create_typedefs_gen();
char * resolve_typedef(char * str);
long expand_struct(char * str, FILE * fdnew, char * parent_name, char * attr_string);
int if_typedef_primitive(char * str);
int definition_exists(char * str);
int definition_visited(char * str);
void reset_bool_alldefs();
int function_ptr(char * str);
short is_typedef(char * str);

//Array stores memory address and primitive data type for static memory
char static_memory_addr[MAX_MEMORY_TYPED_LOCATIONS][MAX_FIELD_WIDTH];
char static_memory_name[MAX_MEMORY_TYPED_LOCATIONS][MAX_FIELD_WIDTH];
char static_memory_type[MAX_MEMORY_TYPED_LOCATIONS][MAX_FIELD_WIDTH];
short static_memory_size[MAX_MEMORY_TYPED_LOCATIONS];
int current_staticmem_location_index = 0;

long datatypes_index_pos[MAX_TYPES];
char datatypes_index_name[MAX_TYPES][MAX_FIELD_WIDTH];
long gen_datatypes_index_pos[MAX_TYPES];
char gen_datatypes_index_name[MAX_TYPES][MAX_FIELD_WIDTH];
int datatypes_index_current =0;
char typedef_name[MAX_TYPES][MAX_FIELD_WIDTH];
char typedef_type[MAX_TYPES][MAX_FIELD_WIDTH];
char all_defs[MAX_TYPES][MAX_FIELD_WIDTH];
short bool_all_defs[MAX_TYPES];


int TOTAL_DATADEFS;
int TYPEDEF_MAX_TYPES =0;
FILE * fddefs;

//JEFF 
#define DEBUG 1

int main()
{
	FILE * fdint;	
#ifndef REMOVE_TEMPS 
	FILE * temp;
#endif

	build_datatypes_index();

	fddefs = fopen("input/typedefs.txt","r");
	if(fddefs == NULL)
	{
		printf("Cannot find the file input/typedefs.txt\n");
		exit(-1);
	}

	//JEFF
	//printf("before create_typedefs_gen\n");
	//Create the expanded version of typedefs.txt file with all composite types expanded
	create_typedefs_gen();
	//JEFF
	//printf("after create_typedefs_gen\n");


	fdint = fopen("input/System.map.types","r");

	if(fdint != NULL)
	{
		//Type information for symbols already exists, use it
		fclose(fdint);
		printf("System.map.types file found. Reading symbol information\n");
		create_memory_types();
	}
	else
	{
		//Generate the type information and save it in file System.map.types	
		FILE * fdsys;
		FILE * fdglob;
		static char globvars_name[MAX_GLOB_VARS][MAX_FIELD_WIDTH];
		static char globvars_type[MAX_GLOB_VARS][MAX_FIELD_WIDTH];
		static int globvars_ds_size[MAX_GLOB_VARS];
		int i=0;
		char buffer[MAX_LINE_INPUT_SIZE];

		
		fdint = fopen("input/System.map.types","w");

		fdsys = fopen("input/System.map","r");
		if(fdsys == NULL)
		{
			printf("Error opening file input/System.map\n");
			exit(-1);
		}
		fdglob = fopen("input/globvars.txt","r");
		if(fdglob == NULL)
		{
			printf("Error opening file input/globvars.txt\n");
			exit(-1);
		}
		
		//Read the globvars.txt file and mmap it or store ina data structure
		//There should be no duplicates in globvars.txt
		fgets(buffer, MAX_LINE_INPUT_SIZE, fdglob);

		while(!feof(fdglob))
		{
			short field_num =1;
			char * ptr1, *ptr2, *ptr3, *ptr4;

#ifdef DEBUG
			printf("main 1: %s\n", buffer);
#endif

			//Get the first field - the string literal "GLOB"
			ptr1 = get_field_info(buffer, field_num++);
			if(ptr1 != NULL)
				assert(strcmp(ptr1, "GLOB") == 0);

			//Get the second field - name of the global variable
			ptr2 = get_field_info(buffer, field_num++);
			assert(ptr2 != NULL);
	
			//Get the third field - type of the global variable
			ptr3 = get_field_info(buffer, field_num++);
			assert(ptr3 != NULL);

			//Get the forth field - storage size of the data structure 
			ptr4 = get_field_info(buffer, field_num++);
			assert(ptr4 != NULL);

			if(ptr4 != NULL)
			{
				// Skips entries whose storage is unknown, such as char arr[]
				if(atoi(ptr4) > 0) 
				{	
					globvars_ds_size[i] = atoi(ptr4);

					if(ptr2 != NULL)
                		strcpy(globvars_name[i],rtrim(ptr2)); 
					if(ptr3 != NULL)
						strcpy(globvars_type[i],rtrim(ptr3));		
				} 
			} 

#ifdef DEBUG 
			printf("main 2\n");
			printf("\n\n%s\n\n", globvars_name[i]);
			printf("\n\n%s\n\n", globvars_type[i]);
			printf("\n\n%d\n\n", globvars_ds_size[i]);
#endif
			i++;
			//Read one line at a time and store in buffer
			fgets(buffer, MAX_LINE_INPUT_SIZE, fdglob);
									
		}		
#ifndef REMOVE_TEMPS 
		temp = fopen("temp_generated/system.map.datatypes","w");
#endif

		//Process one symbol at a time from System.map file
		while(!feof(fdsys))
		{
			char sym_addr[MAX_FIELD_WIDTH];
			char sym_type;
			char sym_name[MAX_FIELD_WIDTH];
			int i;

			fscanf(fdsys, "%s %c %s\n",sym_addr,&sym_type,sym_name);

			for(i=0; i< MAX_GLOB_VARS; i++)
			{
				if(strcmp(globvars_name[i],sym_name) == 0)
				{
					//Found symbol, copy type information to System.map.types
					fprintf(fdint,"%c%s%c ",LEFT_FIELD_DELIMITER, sym_addr, RIGHT_FIELD_DELIMITER);
					fprintf(fdint,"%c%c%c ",LEFT_FIELD_DELIMITER, sym_type, RIGHT_FIELD_DELIMITER);
					fprintf(fdint,"%c%s%c ",LEFT_FIELD_DELIMITER, sym_name, RIGHT_FIELD_DELIMITER);
					fprintf(fdint,"%c%s%c ",LEFT_FIELD_DELIMITER, globvars_type[i], RIGHT_FIELD_DELIMITER);
					fprintf(fdint,"%c%d%c\n",LEFT_FIELD_DELIMITER, globvars_ds_size[i], RIGHT_FIELD_DELIMITER);

#ifndef REMOVE_TEMPS 
					fprintf(temp,"%s\n",globvars_type[i]);
#endif
					break;
				}
			}
		}
#ifndef REMOVE_TEMPS
		fclose(temp);
#endif

		fclose(fdsys);
		fclose(fdglob);
		fclose(fdint);
		fclose(fddefs);
		
	}

}

/* Function creates the expanded version of the typedefs.txt file 
   This function expands all composite types
*/
void create_typedefs_gen()
{
	FILE * fdtypes_orig;
	FILE * fdtypes_new;
	char buffer[MAX_LINE_INPUT_SIZE];
	int arr_index = 0;

	fdtypes_orig = fopen("input/typedefs.txt","r");
	if(fdtypes_orig == NULL)
	{
		printf("Cannot open file input/typedefs.txt to generate expanded version\n");
		exit(-1);
	}	

	fdtypes_new = fopen("input/typedefs.gen","w");
	if(fdtypes_new == NULL)
	{
		printf("Cannot open file input/typedefs.gen \n");
		exit(-1);
	}	

	while(!feof(fdtypes_orig))
	{
		char * decl;
		char * name;
		char * type;
		long pos;

		pos = ftell(fdtypes_orig);
		fgets(buffer,MAX_LINE_INPUT_SIZE,fdtypes_orig);
		if(feof(fdtypes_orig))
			break;
		
		decl = get_field_info(buffer,1);
		name = get_field_info(buffer,2);
		type = get_field_info(buffer,3);


		if((decl != NULL) && (name != NULL) && (type != NULL))
		{
			//typedefs need to be resolved to their basic primitive or composite types
			if(strcmp(decl,"typedef") == 0)
			{
				int bool_index = definition_visited(buffer);
				if(bool_index < 0)
				{
					//Skip this definition
					continue;
				}
				else
				{
					bool_all_defs[bool_index] = 1;
				}

				//JEFF 
				//printf("name: %s, type: %s\n",name,type);
				while((!primitive_type(type)) && (!composite_type(type)))
				{
					long index;
					char strtype[MAX_FIELD_WIDTH];
					char * temp_decl;
					char * temp_name;

					strcpy(strtype, "@typedef| @");
					strcat(strtype, trim(type));
					strcat(strtype, "|");
					index = lookup_datatype_index(strtype);
				
					if(index == -1)
					{
							//Write string as is
							//printf("index not found !\n");
							break;
					}

					temp_decl = get_field_info(datatypes_index_name[index],1);
					temp_name = get_field_info(datatypes_index_name[index],2);
					type = get_field_info(datatypes_index_name[index],3);
				}
				strcpy(typedef_name[arr_index],name);
				strcpy(typedef_type[arr_index],type);
				arr_index++;
				TYPEDEF_MAX_TYPES++;
			}
		}
	}

#ifdef DEBUG
	for(arr_index=0;arr_index < TYPEDEF_MAX_TYPES; arr_index++)
	{
		//fprintf(fdtypes_new,"%s %s\n", typedef_name[arr_index],typedef_type[arr_index]);
		printf("create_typedefs_gen 1: %s %s\n", typedef_name[arr_index],typedef_type[arr_index]);
	}
#endif

	reset_bool_alldefs();
	fseek(fdtypes_orig,0,SEEK_SET);

	arr_index = 0;

	while(!feof(fdtypes_orig))
	{
		char * decl;
		char * name;
		char * type;

		fgets(buffer,MAX_LINE_INPUT_SIZE,fdtypes_orig);
		if(feof(fdtypes_orig))
			break;
		
		decl = get_field_info(buffer,1);
		name = get_field_info(buffer,2);
		type = get_field_info(buffer,3);

		//printf("[%s]\n", buffer);
		if((decl != NULL) && (name != NULL) && (type != NULL))
		{
			//typedefs need to be resolved to their basic primitive or composite types
			if(strcmp(decl,"typedef") == 0)
			{
				char * str;

				int bool_index = definition_visited(buffer);
				if(bool_index < 0)
				{
					//Skip this definition
					continue;
				}
				else
				{
					bool_all_defs[bool_index] = 1;
				}

				if(!function_ptr(type))
				{
					printf("397 before resolve in create_typedefs_gen buffer: %s type: %s\n",buffer,type);
					str = resolve_typedef(type);
				}
				else
				{
					str = type;
				}
				gen_datatypes_index_pos[arr_index] = ftell(fdtypes_new);
				strcpy(gen_datatypes_index_name[arr_index], buffer);
				arr_index++;
				
				if(str != NULL)
					fprintf(fdtypes_new, "@%s| @%s| @%s|;\n",decl, name, str);
				else
					fprintf(fdtypes_new, "@%s| @%s| @%s|;\n",decl, name, type);
			}
		}
		else  //struct/enum definitions follow this path
		{
			if(strstr(buffer,"struct") != NULL)
			{
				long new_pos;

				int bool_index = definition_visited(buffer);
				if(bool_index < 0)
				{
					//Skip this definition
					while((strcmp(trim(buffer),"};") != 0) && (strstr(buffer,ATTR_STRING) == NULL))
					{
						fgets(buffer,MAX_LINE_INPUT_SIZE,fdtypes_orig);
					}
					continue;
				}
				else
				{
					bool_all_defs[bool_index] = 1;
				}

				gen_datatypes_index_pos[arr_index] = ftell(fdtypes_new);
				strcpy(gen_datatypes_index_name[arr_index], buffer);
				arr_index++;

				fprintf(fdtypes_new,"%s\n", buffer);
				//printf("calling expand_struct {%s}\n", buffer);
				new_pos = expand_struct(buffer, fdtypes_new,NULL, NULL);
				//printf("called expand_struct %s\n", buffer);
				//Position the file pointer to the next definition
				fseek(fdtypes_orig, new_pos, SEEK_SET);
				fprintf(fdtypes_new,"%s\n", "};");
				fflush(fdtypes_new);
			}
			else if((strstr(buffer, "union") != NULL) || (strstr(buffer, "enum") != NULL))
			{
				int bool_index = definition_visited(buffer);
				if(bool_index < 0)
				{
					//Skip this definition
					while((strcmp(trim(buffer),"};") != 0) && (strstr(buffer,ATTR_STRING) == NULL))
					{
						fgets(buffer,MAX_LINE_INPUT_SIZE,fdtypes_orig);
					}
					continue;
				}
				else
				{
					bool_all_defs[bool_index] = 1;
				}
				gen_datatypes_index_pos[arr_index] = ftell(fdtypes_new);
				strcpy(gen_datatypes_index_name[arr_index], buffer);
				arr_index++;
				//Simply print them for now
				while((strcmp(trim(buffer),"};") != 0) && (strstr(buffer,ATTR_STRING) == NULL))
				{
					fprintf(fdtypes_new,"%s\n", buffer);
					fgets(buffer,MAX_LINE_INPUT_SIZE,fdtypes_orig);
				}
				fprintf(fdtypes_new,"%s\n", buffer);
			}
		}
	}
	printf("Total definitions =%d %d\n", arr_index, TOTAL_DATADEFS);
	assert(arr_index == TOTAL_DATADEFS);
	fclose(fdtypes_orig);
	fclose(fdtypes_new);
	printf("Finished processing file typedefs.txt\n");
}

#define MISSING_FIELD_NAME "___missing_field_name"
/* Function expands the struct definition and brings it down to primitive types */
long expand_struct(char * str, FILE * fdnew, char * parent_name, char * attr_string)
{
	FILE * fd;
	//JEFF CHANGE
	// causes segment fault in trim()
	//char buffer[MAX_LINE_INPUT_SIZE];
	char *buffer;
	int i;
	long pos;
	short missing_counter =0;

	buffer = (char *)malloc(MAX_LINE_INPUT_SIZE);
	memset(buffer,0,MAX_LINE_INPUT_SIZE);

	fd = fopen("input/typedefs.txt","r");

	i = lookup_datatype_index(trim(str));
	pos = datatypes_index_pos[i]; 

	if(pos < 0)
		printf("Could not find definition %s\n", str);

	if(fseek(fd,pos, SEEK_SET) != 0)
		printf("Could not position file ptr\n");

	fgets(buffer, MAX_LINE_INPUT_SIZE, fd);
	printf("\n\n ---- [%s] [%s] ---\n", buffer, str);


	assert(strcmp(trim(buffer),str) == 0);
	
	fgets(buffer, MAX_LINE_INPUT_SIZE, fd);

	while((strcmp(trim(buffer),"};") != 0) && (strstr(buffer,ATTR_STRING) == NULL))
	{
		char * literal;
		char * type;
		char * name;
		char type_string[MAX_FIELD_WIDTH];
		char strattr[MAX_FIELD_WIDTH];
		char * substr;
		char missing_name[MAX_FIELD_WIDTH];
		//JEFF was segment fault here
		// changed how buffer was defined
		literal = trim(get_field_info(buffer,1));
          type = trim(get_field_info(buffer,2));
		
		strattr[0]='\0';
		strcpy(type_string, type);

		if((substr= strstr(type,ATTRIBUTE_STRING)) != NULL)
		{
			strcpy(strattr, substr);
			substr[0] = '\0';	
			type = trim(type);
		}

        name = trim(get_field_info(buffer,3));

		
		assert(strcmp(literal,"field") == 0);

		if(strcmp(name,MISSING_FIELD_NAME) == 0)
        {
        	char strmiscounter[MAX_FIELD_WIDTH];
                                                                                                                                               
            sprintf(strmiscounter,"%d",missing_counter++);
            strcpy(missing_name, name);
            strcat(missing_name, strmiscounter);
            name = missing_name;
        }

		if(function_ptr(type))
		{
			//fprintf(fdnew,"%s\n", buffer);
			if(parent_name != NULL)
			{
				char new_name[MAX_FIELD_WIDTH];

				strcpy(new_name, parent_name);
				strcat(new_name, "___");
				strcat(new_name, name);
				
				fprintf(fdnew,"\t@%s| @%s| @%s|;\n", literal, type, new_name);
			}
			else
			{
				fprintf(fdnew,"\t@%s| @%s| @%s|;\n", literal, type, name);
			}
		}
		else if(primitive_type(type) || if_typedef_primitive(type))
		{
			//printf("Prim type = %d\n", primitive_type(type));
			//printf("Typedeftype = %d\n", if_typedef_primitive(type));
			//printf("primitive type =yes %s %s %s\n", literal, type, name);
			//Struct field i s a primitive type - simply dump as is
			if(parent_name == NULL)
			{
				//fprintf(fdnew,"%s\n", buffer);
				//JEFF removed tab
				fprintf(fdnew,"\t@%s| @%s| @%s|;\n", literal, type, name);
				//fprintf(fdnew,"     @%s| @%s| @%s|;\n", literal, type, name);
			}
			else
			{
				char fieldstr[MAX_LINE_INPUT_SIZE];

				strcpy(fieldstr, "@");
				strcat(fieldstr, literal);
				strcat(fieldstr, "| ");
				strcat(fieldstr, "@");
				strcat(fieldstr, type_string);
				
				if(attr_string != NULL)
				{
					strcat(fieldstr, " ");
                	strcat(fieldstr, attr_string);
				}

				strcat(fieldstr, "| ");
				strcat(fieldstr, "@");
				strcat(fieldstr, parent_name);
				strcat(fieldstr, "___");
				strcat(fieldstr, name);
				strcat(fieldstr, "|;");

				fprintf(fdnew,"\t%s\n", fieldstr);
			}
		}
		else
		{
			//Struct field is a struct/union or enum
			char * ptr;
			char strtype[MAX_FIELD_WIDTH];
			char tmpbuf[MAX_LINE_INPUT_SIZE];
			short found_zone_t=0;
			char strsubtype[MAX_FIELD_WIDTH];
			strsubtype[0] = '\0';
			
	if(strstr(buffer,"zone_t") != NULL)
	{
		printf("found zone_t type=%s\n", type);
		found_zone_t = 1;
	}

			//First check if it is a typedef here, if so resolve it
			if(!function_ptr(type))
			{
				if(is_typedef(type))
				{
					char * tmp;
					

					if(strstr(type,"*") != NULL)
					{	
						tmp = strstr(type,"*");
						strcpy(strsubtype, tmp);
					}
					else if(strstr(type, "[") != NULL)
					{
						tmp = strstr(type,"[");
						strcpy(strsubtype, tmp);
					}
				}
			// JEFF	printf("650 before resolve in expand_struct buffer: %s type: %s\n",buffer,type);
				ptr = resolve_typedef(type);
				
			}
			else
			{
				ptr = type;
			}
			//printf("ES type=[%s] ptr=[%s]\n", type, ptr);
			if(ptr != NULL) //This is indeed a typedef
			{
				strcpy(strtype, trim(ptr));
				strcpy(type, trim(ptr));
			}
			else
			{
				strcpy(strtype, type);
			}
			if(strlen(strsubtype) > 0)
			{
				strcat(strtype, " ");
				strcat(strtype, strsubtype);
			}
		if(found_zone_t == 1)
		{
			printf("strtype = %s\n", strtype);
		}
			ptr = strtok(strtype," ");
			//This can be struct, union or enum

			if(strcmp(ptr,"struct") == 0)
			{
				int arr_index = 1;
				int i;
				char * place_null;

				strcpy(tmpbuf, type);
				//Take care of arrays - if there is array information, remove it
				if((place_null = strstr(tmpbuf,"[")) != NULL)
				{
					*place_null = '\0';
					trim(tmpbuf);
				}
				strcat(tmpbuf, " {");

				/* Check if it is a struct array, if so get array index */
				//Begin
				ptr = strtok(NULL," "); //Skip the name	
				ptr = strtok(NULL," "); // This should not be NULL if it is a array or ptr

				if(ptr != NULL)
				{
					char * tmp;
					//Get array index
					assert(strstr(ptr,"[") != NULL);
					assert(strstr(ptr,"]") != NULL);

					tmp = strstr(ptr,"[");
					tmp++;

					arr_index = strtol(tmp,NULL,10);
				
				}
				
				for(i=0; i<arr_index; i++)
				{	
					char index[4];
					char new_name[MAX_FIELD_WIDTH];

					sprintf(index,"%d",i);
				//End	
				//printf("//calling expand_struct {%s} tmpbuf =[%s]\n", buffer, tmpbuf);
					if(parent_name == NULL)
					{
						strcpy(new_name, name);
						strcat(new_name,index);
						expand_struct(tmpbuf, fdnew, new_name, strattr);	
					}
					else
					{
						char new_attr_string[MAX_FIELD_WIDTH];

						strcpy(new_name, parent_name);
						strcat(new_name,index);
						strcat(new_name, "___");
						strcat(new_name, name);

						if(attr_string != NULL)
						{
							strcpy(new_attr_string, attr_string);

							if(strlen(strattr)  > 0)
							{
								strcat(new_attr_string, " ");
								strcat(new_attr_string, strattr);
							}
							expand_struct(tmpbuf, fdnew, new_name, new_attr_string);	
						}
						else if(strlen(strattr) > 0)
						{
							expand_struct(tmpbuf, fdnew, new_name, strattr);	
						}
						else
						{
							expand_struct(tmpbuf, fdnew, new_name, NULL);	
						}
					}
				} // Addtional line for arrays
					
			}
			else if((strcmp(ptr,"union") == 0) || (strcmp(ptr,"enum") == 0))
			{
				//fprintf(fdnew,"%s\n", buffer);
				if(parent_name != NULL)
				{
					char new_name[MAX_FIELD_WIDTH];

					strcpy(new_name, parent_name);	
					strcat(new_name, "___");
					strcat(new_name, name);
					fprintf(fdnew,"\t@%s| @%s| @%s|;\n", literal, type, new_name);
					//fprintf(fdnew,"     @%s| @%s| @%s|;\n", literal, type, new_name);
				}	
				else
				{
					fprintf(fdnew,"\t@%s| @%s| @%s|;\n", literal, type, name);
					//fprintf(fdnew,"     @%s| @%s| @%s|;\n", literal, type, name);
				}
			}
		}	
		fgets(buffer, MAX_LINE_INPUT_SIZE, fd);
	}		

	pos = ftell(fd);
	fclose(fd);

	return(pos);
}

/* Function returns -1 if the definition is already considered
	else returns the index where the definition is stored in
    the all_defs array */ 

int definition_visited(char * str)
{
	int i;

	for(i=0; i<TOTAL_DATADEFS; i++)
	{
		if(strcmp(trim(str),trim(all_defs[i])) == 0)
		{
			if(bool_all_defs[i] == 1)
			{
				return(-1);
			}
			else if(bool_all_defs[i] == 0)
			{
				return(i);
			}
		}
	}
	printf("Definition not found! ...oops [%s]\n",str);
	exit(-1);
}

void reset_bool_alldefs()
{
	int i;
                                                                                                                                               
    for(i=0; i<TOTAL_DATADEFS; i++)
    {
		bool_all_defs[i] = 0;
    }
}

int function_ptr(char * str)
{
	char func_def[MAX_FIELD_WIDTH];
	int len;

	strcpy(func_def, str);
	trim(func_def);

	len = strlen(func_def);

	if(strstr(func_def, "(*)") != NULL) 
	{
		//if((str[strlen(str) -1] == ')') || ((str[strlen(str) -2] == ')') && (str[strlen(str) -1] == ';')))
		{
        	return(1);
		}
	}
	else if(((strstr(func_def, "(") != NULL) && (strstr(func_def, ")") != NULL))  && (strstr(func_def,ATTRIBUTE_STRING) == NULL))
	{
		//if((str[strlen(str) -1] == ')') || ((str[strlen(str) -2] == ')') && (str[strlen(str) -1] == ';')))
		{
        	return(1);
		}
	}
	return(0);
}

/* Function returns 1 if given string type "str" is a primitive data type.
   Else returns 0
*/

int primitive_type(char * str)
{
	char tempstr[MAX_FIELD_WIDTH];
	char * ptr;

	strcpy(tempstr, str);

	//Check if function pointer - also a primitive type
	//if((strstr(tempstr, "(*)(") != 0) && (tempstr[strlen(tempstr) -1] == ')'))
	if(function_ptr(tempstr))
		return(1);

	//Check if it is any type of pointer
	if(tempstr[strlen(tempstr) -1] == '*')
		return(1);
	

	ptr = strtok(tempstr," ");
	//JEFF
	//printf("primitive_type: %s: |%s|\n",str, ptr);
	if((strcmp(ptr,"unsigned") == 0) || (strcmp(ptr,"int") == 0) || (strcmp(ptr,"char") == 0) ||
       (strcmp(ptr,"long") == 0) || (strcmp(ptr,"void") == 0) ||  (strcmp(ptr,"short") == 0) || 
	   (strcmp(ptr,"signed") == 0) || (strcmp(ptr,"double") == 0)) 
	{
		return(1);
	}
	else if((strcmp(ptr,"struct") == 0) || (strcmp(ptr,"union") == 0) || (strcmp(ptr,"enum") == 0))
	{
		ptr = strtok(NULL," "); //Skip the name
		ptr = strtok(NULL," ");
		//Check if it is a pointer or pointer array to any of these types
		if(ptr != NULL)
		{
			if(strcmp(ptr,"const") == 0)
				ptr = strtok(NULL," ");

			if(ptr !=NULL)
			{
				//if ((strstr(ptr,"*") != NULL) || (strstr(ptr, "[") != NULL))
				if (strstr(ptr,"*") != NULL)
				{
						return(1);	
				}
			}
		}
	}
	else //Should also include pointers, or pointer arrays to typedefs 
	{
		ptr = strtok(NULL," "); //Skip the name
        //Check if it is a pointer or pointer array to any of these types
        if(ptr != NULL)
        {
            if(strcmp(ptr,"const") == 0)
                ptr = strtok(NULL," ");
                                                                                                                                               
            if(ptr !=NULL)
            {
                //if ((strstr(ptr,"*") != NULL) || (strstr(ptr, "[") != NULL))
                if (strstr(ptr,"*") != NULL)
                {
                        return(1);
                }
            }
        }
	}

	return(0);
}


int if_typedef_primitive(char * ptr)
{
	char * str;

	//Check if typedef resolves to primitive type
	if(!function_ptr(ptr))
	{
		//JEFF printf("933 before resolve in if_typedef_primitive ptr: %s\n",ptr);
		str = resolve_typedef(ptr);	
	}
	else
	{
		str = ptr;
	}

	//printf("resolving typedef = %s ptr=[%s]\n", str, ptr);

	if(str != NULL)
	{
		//Check if this is a primitive type
		if(primitive_type(str) == 1)
			return 1; 
	}
	else
	{
		if((strstr(ptr,"struct") == 0) && (strstr(ptr,"union") == 0) && (strstr(ptr,"enum") == 0))
		{
			printf("Could not resolve type [%s]\n",ptr);
			exit(-1);
		}
	}
	return 0;
}

/* Function returns 1 if given string type "str" is a primitive data type.
   Else returns 0
*/
int composite_type(char * str)
{
	char tempstr[MAX_FIELD_WIDTH];
	char * ptr;

	strcpy(tempstr, str);
	ptr = strtok(tempstr," ");
	
	if((strcmp(ptr,"struct") == 0) || (strcmp(ptr,"union") == 0) || (strcmp(ptr,"enum") == 0)) 
	{
		return(1);
	}
	else
		return(0);
}


/* Function reads from file System.map.types
   Reads each symbol and gets it's type
   Calls function type_memory_location() to assign primitive types to the 
   given memory region 
*/
void create_memory_types()
{
	FILE * fdint;
	char buffer[MAX_LINE_INPUT_SIZE];

	fdint = fopen("input/System.map.types","r");

	if(fdint == NULL)
	{
		printf("Error opening file System.map.types\n");
		exit(-1);
	}

	while(!feof(fdint))
	{
		char * ptr;
		char sym_addr[MAX_FIELD_WIDTH];
		char sym_type;
		char sym_name[MAX_FIELD_WIDTH];
		char ds_type[MAX_FIELD_WIDTH];
		int ds_size;
		
		fgets(buffer, MAX_LINE_INPUT_SIZE, fdint);
		if(feof(fdint))
			break;		

		//Field1 - symbol addr
		ptr = get_field_info(buffer, 1);
		if(ptr != NULL)
			strcpy(sym_addr, ptr);

		//Field2 - symbol type d|D|b|B
		ptr = get_field_info(buffer, 2);
		if(ptr != NULL)
			sym_type =  ptr[0];

		//Field3 - symbol name
		ptr = get_field_info(buffer, 3);
		if(ptr != NULL)
			strcpy(sym_name, ptr);

		//Field4 - symbol data structure declaration
		ptr = get_field_info(buffer, 4);
		if(ptr != NULL)
			strcpy(ds_type, ptr);

		//Field5 - symbol data size 
		ptr = get_field_info(buffer, 5);
		if(ptr != NULL)
			ds_size = atoi(ptr);

		type_memory_location(sym_addr, sym_type, sym_name, ds_type, ds_size);
	}	
	print_memory_types();
}

void type_memory_location(char * sym_addr, char sym_type, char * sym_name,  
						char * ds_type, int ds_size)
{
	char * ptr;
	char temp_ds_type[MAX_FIELD_WIDTH];
	char str_ds_type[MAX_FIELD_WIDTH];
#ifdef DEBUG
	printf("%s %c %s %s %d\n", sym_addr, sym_type, sym_name, ds_type, ds_size);
#endif
	strcpy(temp_ds_type, ds_type);
	strcpy(str_ds_type, ds_type);
	
	//Also, handle function pointers right here
	//if((strstr(ds_type, "(*)(") != 0) && (ds_type[strlen(ds_type) -1] == ')'))
	if(function_ptr(ds_type))
	{
		unsigned long long ds_addr =  strtoll(sym_addr,NULL,16);
		// JEFFprintf("typemem location %s type=%s\n", sym_name, ds_type);
		update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(void *));
		return;
	}
	//Also handle all types of pointers
    if(ds_type[strlen(ds_type) -1] == '*')
	{
		unsigned long long ds_addr =  strtoll(sym_addr,NULL,16);
		update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(void *));
        return;
	}

	//Also handle all types of pointer arrays
    if((ds_type[strlen(ds_type) -1] == ']') && (strstr(ds_type,"*") != NULL))
	{
		unsigned long long ds_addr =  strtoll(sym_addr,NULL,16);

		//Get the array indices
		{
            //- pointer array
            char * start_index, * end_index;
            char str_arr_index[5];
            int arr_index;
                                                                                                                                               
            start_index = index(ds_type,'[');
            end_index = index(ds_type, ']');
            int i=0;
                                                                                                                                               
            while(start_index < end_index)
            {
                ++start_index;
                str_arr_index[i++] = *(char *)start_index;
            }
            str_arr_index[i + 1] ='\0';
            arr_index = atoi(str_arr_index);
                                                                                                                                               
            //Check here is array is two dimensional array
            if(strchr(end_index,'[') != NULL)
            {
                //Get the second index
                char str_arr_index2[5];
                                                                                                                                               
                i=0;
                start_index = end_index + 1;
                end_index = strchr(start_index,']');
                                                                                                                                               
                while(start_index < end_index)
                {
                    ++start_index;
                    str_arr_index2[i++] = *(char *)start_index;
                }
                str_arr_index2[i + 1] ='\0';
                arr_index = arr_index * atoi(str_arr_index2);
            }
                                                                                                                                               
            for(i=0;i<arr_index;i++)
            {
                update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(void *));
                ds_addr = ds_addr +  sizeof(void *);
            }
        }

        return;
	}

	
	
	if(!primitive_type(ds_type)) 
	{
		char * tmp, *strtmp;
		char strdstype[MAX_FIELD_WIDTH];

		//It is a typedef datatype, resolve the typedef 
		strcpy(strdstype, ds_type);
		
		strtmp = strtok(strdstype," ");
		//JEFFprintf("1134 before resolve in type_memory_location strtmp: %s\n",strtmp);
		tmp = resolve_typedef(strtmp);
	
		//JEFFprintf("arg: %s reolve_typedef: %s\n",strtmp,tmp);

		if(tmp != NULL)
		{
		
			strcpy(str_ds_type, tmp);
			strcpy(temp_ds_type, tmp);

			tmp = strtok(NULL, " ");
			if(tmp != NULL)
			{
				strcat(str_ds_type, tmp);
				strcat(temp_ds_type, tmp);
			}
		}
		else
		{	
			//printf("Could not resolve type [%s]\n", str_ds_type);
		}
	}

	
	//Examine the data structure declaration and handle it
	ptr = strtok(temp_ds_type," ");

	
	assert(ptr != NULL);

	if((strcmp(trim(ptr), "unsigned") == 0) || (strcmp(trim(ptr), "signed") == 0))
	{
		ptr = strtok(NULL, " ");

		assert(ptr != NULL);
		if(strcmp(ptr,"char") == 0)
		{
			//This type may be either unsigned char or unsigned char * or unsigned char **
			//or unsigned char [] or unsigned char [][] or unsigned char volatile
			handle_char_datatypes(ptr, sym_addr, sym_type, sym_name, str_ds_type, ds_size);
		}
		else if(strcmp(ptr,"int") == 0)
		{
			handle_int_datatypes(ptr, sym_addr, sym_type, sym_name, str_ds_type, ds_size);
		}
		else if(strcmp(ptr,"long") == 0)
		{
			handle_long_datatypes(ptr, sym_addr, sym_type, sym_name, str_ds_type, ds_size);
		}
		else if(strcmp(ptr,"short") == 0)
		{
			handle_short_datatypes(ptr, sym_addr, sym_type, sym_name, str_ds_type, ds_size);
		}
		else if(strcmp(ptr,"double") == 0)
		{
			handle_double_datatypes(ptr, sym_addr, sym_type, sym_name, str_ds_type, ds_size);
		}
	}
	else if(strcmp(trim(ptr),"int") == 0)
	{	
		handle_int_datatypes(ptr, sym_addr, sym_type, sym_name, str_ds_type, ds_size);
	}
	else if(strcmp(trim(ptr),"long") == 0)
	{	
		handle_long_datatypes(ptr, sym_addr, sym_type, sym_name, str_ds_type, ds_size);
	}
	else if(strcmp(trim(ptr),"short") == 0)
	{	
		handle_short_datatypes(ptr, sym_addr, sym_type, sym_name, str_ds_type, ds_size);
	}
	else if(strcmp(ptr,"double") == 0)
	{
		handle_double_datatypes(ptr, sym_addr, sym_type, sym_name, str_ds_type, ds_size);
	}
	else if(strcmp(trim(ptr),"char") == 0)
	{
		handle_char_datatypes(ptr, sym_addr, sym_type, sym_name, str_ds_type, ds_size);
	}
	else if(strcmp(trim(ptr),"struct") == 0)
	{
		handle_struct_datatypes(ptr, sym_addr, sym_type, sym_name, str_ds_type, ds_size);
	}
	else if(strcmp(trim(ptr),"union") == 0)
	{
		handle_union_datatypes(ptr, sym_addr, sym_type, sym_name, str_ds_type, ds_size);
	}
	else if(strcmp(trim(ptr),"enum") == 0)
	{
		//Treat enum like one integer
		handle_int_datatypes(ptr, sym_addr, sym_type, sym_name, str_ds_type, ds_size);
	}
	else if(strcmp(trim(ptr),"void") == 0)
	{
		handle_void_datatypes(ptr, sym_addr, sym_type, sym_name, str_ds_type, ds_size);
	}
	else if(strcmp(trim(ptr),"_Bool") == 0){
		// JEFF
		//printf("ptr: %s trim ptr: %s\n",ptr,trim(ptr));
		//printf("handle _Bool dataype\n");
		handle__Bool_datatypes(ptr, sym_addr, sym_type, sym_name, str_ds_type, ds_size);
	}
	else
	{	
		int i;
		for(i=0;i < TYPEDEF_MAX_TYPES; i++)
		{
			//fprintf(fdtypes_new,"%s %s\n", typedef_name[arr_index],typedef_type[arr_index]);
			printf("create_typedefs_gen 1: %s %s %d\n", typedef_name[i],typedef_type[i],i);
		}
		printf("[Line %d] Unknown datatype %s\n", __LINE__,str_ds_type);
		exit(-1);
	}
}

/* Returns the resolved type of the given typedef statement, else returns NULL */ 
char * resolve_typedef(char * str)
{
    int i;
	char tempstr[MAX_LINE_INPUT_SIZE];	
	char * ptr;

	strcpy(tempstr, str);

	//Expression has either an array or pointer in it 
	if((strstr(tempstr,"[") != NULL) || (strstr(tempstr,"*") != NULL))
	{
		ptr = strtok(tempstr," ");
	}
	else
	{
		ptr = tempstr;
	} 
	
	//JEFF printf("CHECK typedef_type: %s %s\n",typedef_name[0],typedef_type[0]);
                                                                                                                              
    for(i=0; i< TYPEDEF_MAX_TYPES; i++)
    {
	//printf("typedef_name: %s, trim: %s, %d\n",typedef_name[i], trim(ptr),strcmp(typedef_name[i], trim(ptr)));
        if(strcmp(typedef_name[i], trim(ptr)) == 0)
        {
            return(typedef_type[i]);
        }
    }
	
    return(NULL);
}


/* Returns the offset within the file typedefs.txt where the 
   corresponding definition can be found 
   Consider storing this index sorted and then use binary search for lookups */
long lookup_datatype_index(char * str)
{
	int i;

	for(i=0; i< TOTAL_DATADEFS; i++)
	{
		//JEFF  REMOVE THIS
		//printf("[%s] [%s] %d %d\n", datatypes_index_name[i], str,i, TOTAL_DATADEFS);
		if(strstr(datatypes_index_name[i], str) != NULL)
		{
			return(i);
		}
	}
	return(-1);
}

/* Returns the offset within the file typedefs.gen where the 
   corresponding definition can be found 
   Consider storing this index sorted and then use binary search for lookups */
long lookup_gen_datatype_index(char * str)
{
	int i;

	for(i=0; i< TOTAL_DATADEFS; i++)
	{
		//strstr NULL even though eqaul?
		if(strstr(str,"atomic_t_8") != NULL){
			//printf("[%s] [%s] %d\n", datatypes_index_name[i], str, strcmp(datatypes_index_name[i],str));
			if(strcmp(datatypes_index_name[i],str) == 0){
				return(i);
			}
		}
		//printf("[%s] [%s]\n", datatypes_index_name[i], str);
		if(strstr(gen_datatypes_index_name[i], str) != NULL)
		{
			return(i);
		}
	}
	
	
	return(-1);
}

/* This function builds an index of data structure definition
   and it's corresponding position within the file, so lookup is quick
*/

void build_datatypes_index()
{
	FILE * fdtypes;
	char buffer[MAX_LINE_INPUT_SIZE];
	long pos;

	fdtypes = fopen("input/typedefs.txt","r");
	if(fdtypes == NULL)
	{
		printf("Cannot find file input/typedefs.txt\n");
		exit(-1);
	}

	while(!feof(fdtypes))
	{
		pos = ftell(fdtypes);
		fgets(buffer, MAX_LINE_INPUT_SIZE, fdtypes);
	
		if(((strstr(buffer,"struct") != NULL) && (buffer[strlen(trim(buffer)) -1] == '{'))  || 
		   ((strstr(buffer,"union") != NULL) && (buffer[strlen(trim(buffer)) - 1] == '{'))  || 
		   ((strstr(buffer,"enum") != NULL) && (buffer[strlen(trim(buffer)) - 1] == '{'))   ||
           (strstr(buffer,"typedef") != NULL)) 
		{
			//Definition encountered
#ifdef DEBUG
			printf("Definition encountered: %s\n", buffer);
#endif
			if(!definition_exists(buffer))
			{
				strcpy(datatypes_index_name[datatypes_index_current],buffer);
				datatypes_index_pos[datatypes_index_current] = pos;
				strcpy(all_defs[datatypes_index_current], buffer);
				bool_all_defs[datatypes_index_current] = 0;
				//printf("%s\n", all_defs[datatypes_index_current]);
				datatypes_index_current++;
				TOTAL_DATADEFS++;
			}
		}
	}

	printf("Total data type definitions = %d\n", TOTAL_DATADEFS);
}

int definition_exists(char * str)
{
	int i;

	for(i=0; i< TOTAL_DATADEFS; i++)
	{
		if(strcmp(all_defs[i], str) ==0)
		{
			return(1);
		}
	}
	return(0);
}

/* Function prints the typed static memory to a file memory.map.static*/
void print_memory_types()
{
	int i;

	FILE * fd_mem_map;

	fd_mem_map = fopen("input/memory.map.static","w");

	if(fd_mem_map == NULL)
	{
		printf("Cannot create file input/memory.map.static for writing \n");
		exit(-1);
	}
	
	if(fd_mem_map != NULL)
	{ 
		printf("Printing static memory types .... \n");
		fprintf(fd_mem_map, "Total mem location types =%d\n", current_staticmem_location_index);
		for(i=0; i< current_staticmem_location_index; i++)
		{
			
			fprintf(fd_mem_map,"%c%s%c ",LEFT_FIELD_DELIMITER, static_memory_addr[i], RIGHT_FIELD_DELIMITER);
			fprintf(fd_mem_map,"%c%s%c ",LEFT_FIELD_DELIMITER, static_memory_type[i], RIGHT_FIELD_DELIMITER);
			fprintf(fd_mem_map,"%c%s%c ",LEFT_FIELD_DELIMITER, static_memory_name[i], RIGHT_FIELD_DELIMITER);
			fprintf(fd_mem_map,"%c%d%c\n",LEFT_FIELD_DELIMITER, static_memory_size[i], RIGHT_FIELD_DELIMITER);
			//fprintf(fd_mem_map, "[%s] [%s] [%s] [%d]\n", static_memory_addr[i], static_memory_type[i], static_memory_name[i], static_memory_size[i]);
		}
	}

	fclose(fd_mem_map);
}

unsigned long long handle_struct_datatypes(char * ptr, char * sym_addr, char sym_type, char * sym_name,
                        char * ds_type, int ds_size)
{
	unsigned long long ds_addr;
	unsigned long long ret_ds_addr;
	long pos;
	FILE * fddefs_gen;
	FILE * fd_off;

 	//This type may be either struct / struct  * / struct ** /
	// struct [] / struct [][]  
	//printf("%s %c %s %s %d\n", sym_addr, sym_type, sym_name, ds_type, ds_size);
	ds_addr = strtoll(sym_addr,NULL,16);
	ret_ds_addr = ds_addr;
	ptr = strtok(NULL," ");

	//assert(strcmp(trim(ptr),sym_name) == 0);

	ptr = strtok(NULL," ");
	if((ptr == NULL) || (strncmp(ptr,ATTRIBUTE_STRING,ATTRIBUTE_STRING_LEN) == 0))
	{
		//This is a struct 
		// Get struct fields and update memory locations
		long offset;
		long index;
		char buffer[MAX_LINE_INPUT_SIZE];
		char strtype[MAX_FIELD_WIDTH];
		long ret_offset;
		char offsetbuf[MAX_LINE_INPUT_SIZE];
		int field_offset =0;
		char substr[MAX_FIELD_WIDTH];
		//Look up the datatypes_index to find position of definition in file

		fddefs_gen = fopen("input/typedefs.gen","r");
		if(fddefs_gen == NULL)
		{
			printf("Cannot find the file input/typedefs.gen \n");
			exit(-1);
		}

		fd_off = fopen("input/offsets.gen","r");
		if(fd_off == NULL)
		{
			printf("Cannot find the file input/offsets.gen \n");
			exit(-1);
		}

		strcpy(substr,ds_type);
		if(strstr(ds_type,ATTRIBUTE_STRING) != NULL)
		{
			char * attr_ptr;
			attr_ptr = strstr(substr,ATTRIBUTE_STRING);
			attr_ptr[0]='\0';
		}
			//JEFFprintf("attr =%s\n", substr);

		//Locate the struct in the offset file
		fgets(offsetbuf, MAX_LINE_INPUT_SIZE, fd_off);	
		while(!feof(fd_off))
		{
			if(strcmp(trim(offsetbuf),trim(substr)) == 0)
			{
				break;
			}
			fgets(offsetbuf, MAX_LINE_INPUT_SIZE, fd_off);	
		}

		

		strcpy(strtype, trim(substr));
		strcat(strtype, " {");
		index= lookup_gen_datatype_index(strtype);
		if(index < 0)
		{
			printf("Cannot locate datatype %s\n", strtype);
		}
		offset = gen_datatypes_index_pos[index];

		//Code segfaults in fseek statement
		fseek(fddefs_gen, offset, SEEK_SET);  	
		fgets(buffer, MAX_LINE_INPUT_SIZE, fddefs_gen);	
	
		if(strcmp(trim(buffer), gen_datatypes_index_name[index]) == 0)
		{
			char * field_name;

			//Go over each field and type memory
			fgets(buffer, MAX_LINE_INPUT_SIZE, fddefs_gen);
		    while((strcmp(trim(buffer),"};") != 0) && (strstr(buffer,ATTR_STRING) == NULL))
			{
				//Process this field - Format is 
				// @field| @type| @name|
				char * ptr;
				char strtype[MAX_FIELD_WIDTH];
				char temp_strtype[MAX_FIELD_WIDTH];
				char * tempptr;
				char * tmp;
				char * stroffset;
				
				//Reads line to get offset of each field
				fgets(offsetbuf, MAX_LINE_INPUT_SIZE, fd_off);	
				stroffset = strtok(offsetbuf," ");
				stroffset = strtok(NULL," ");
				//printf("buffer=%s offsetbuf =%s\n", buffer,offsetbuf);
				field_offset = strtol(trim(stroffset), NULL,10);


				ptr = get_field_info(buffer,1);
				assert(strcmp("field",ptr) == 0);

				ptr= get_field_info(buffer,2);
				strcpy(strtype, ptr);
				strcpy(temp_strtype, ptr);

				//This is the field name
				field_name = get_field_info(buffer,3);

				//Also, handle function pointers right here
				if(function_ptr(strtype))
				{
					char fname[MAX_FIELD_WIDTH];
					unsigned long long new_ds_addr;
					//unsigned long long ds_addr =  strtoll(sym_addr,NULL,16);

					strcpy(fname, sym_name);
					strcat(fname, "->");
					strcat(fname, field_name);

					new_ds_addr = ds_addr + field_offset;
					update_static_mem_array(new_ds_addr, fname, strtype, sizeof(void *));
					//ds_addr = ds_addr + sizeof(void *); 
					ret_ds_addr = ret_ds_addr + sizeof(void *);
					fgets(buffer, MAX_LINE_INPUT_SIZE, fddefs_gen);
					continue;
				}
				
				tempptr = strtok(temp_strtype," ");

				//It is a typedef datatype, resolve it before processing any further 
				//Takes care of typedefs, typedef pointers, typedef arrays
				//JEFF printf("1663 before resolve in handle_struct_datatypes buffer: %s tempptr: %s\n",buffer,tempptr);
				tmp = resolve_typedef(tempptr);
				if(tmp != NULL)
				{
					strcpy(strtype, tmp);
					tmp = strtok(NULL," ");
					if(tmp != NULL)
					{
						strcat(strtype, " ");
						strcat(strtype,tmp);
					}
				}

				//Also, check again for function pointers 
				if(function_ptr(strtype))
				{
					char fname[MAX_FIELD_WIDTH];
					unsigned long long new_ds_addr;
					//unsigned long long ds_addr =  strtoll(sym_addr,NULL,16);

					strcpy(fname, sym_name);
					strcat(fname, "->");
					strcat(fname, field_name);

					new_ds_addr = ds_addr + field_offset;
					update_static_mem_array(new_ds_addr, fname, strtype, sizeof(void *));
					//ds_addr = ds_addr + sizeof(void *); 
					ret_ds_addr = ret_ds_addr + sizeof(void *);
					fgets(buffer, MAX_LINE_INPUT_SIZE, fddefs_gen);
					continue;
				}

				//Also handle all types of pointers
				if(strtype[strlen(strtype) -1] == '*')
				{
					char fname[MAX_FIELD_WIDTH];
					unsigned long long new_ds_addr;
					//unsigned long long ds_addr =  strtoll(sym_addr,NULL,16);

					strcpy(fname, sym_name);
					strcat(fname, "->");
					strcat(fname, field_name);

					new_ds_addr = ds_addr + field_offset;
					update_static_mem_array(new_ds_addr, fname, strtype, sizeof(void *));
					//ds_addr = ds_addr + sizeof(void *); 
					ret_ds_addr = ret_ds_addr + sizeof(void *);
					fgets(buffer, MAX_LINE_INPUT_SIZE, fddefs_gen);
					continue;
				}

				strcpy(temp_strtype, strtype);
				//Find data type and pass to appropriate function
				ptr = strtok(temp_strtype," "); 
				if((strcmp(ptr,"unsigned") == 0) || (strcmp(ptr,"signed") == 0))
				{
					ptr = strtok(NULL," ");
				}
				if(strcmp(ptr,"char") == 0)
				{
					char addr[10];
					char fname[MAX_FIELD_WIDTH];
					unsigned long long new_ds_addr;

					new_ds_addr = ds_addr + field_offset;
					strcpy(fname, sym_name);
					strcat(fname, "->");
					strcat(fname, field_name);
					sprintf(addr,"%x",new_ds_addr);
					
					//printf("addr = %s\n", addr);
					//ds_addr = handle_char_datatypes(ptr, addr, sym_type, fname, strtype, ds_size);
					ret_ds_addr = handle_char_datatypes(ptr, addr, sym_type, fname, strtype, ds_size);
				}
				else if((strcmp(ptr,"int") == 0) || (strcmp(ptr,"enum") == 0))
				{
					char addr[10];
					char fname[MAX_FIELD_WIDTH];
					unsigned long long new_ds_addr;
 
					new_ds_addr = ds_addr + field_offset;

					printf("0x%x %d\n", ds_addr, field_offset);
					
					strcpy(fname, sym_name);
					strcat(fname, "->");
					strcat(fname, field_name);
					sprintf(addr,"%x",new_ds_addr);

					//ds_addr = handle_int_datatypes(ptr, addr, sym_type, fname, strtype, ds_size);
					printf("before handle_int..addr = 0x%x\n",ret_ds_addr);
					ret_ds_addr = handle_int_datatypes(ptr, addr, sym_type, fname, strtype, ds_size);
					printf("in handle_int..ret addr = 0x%x\n",ret_ds_addr);
				}
				else if(strcmp(ptr,"short") == 0)
				{
					char addr[10];
					char fname[MAX_FIELD_WIDTH];
					unsigned long long new_ds_addr;

					new_ds_addr = ds_addr + field_offset;
					strcpy(fname, sym_name);
					strcat(fname, "->");
					strcat(fname, field_name);
					sprintf(addr,"%x",new_ds_addr);
					//ds_addr = handle_short_datatypes(ptr, addr, sym_type, fname, strtype, ds_size);
					ret_ds_addr = handle_short_datatypes(ptr, addr, sym_type, fname, strtype, ds_size);
				}
				else if(strcmp(ptr,"long") == 0)
				{
					char addr[10];
					char fname[MAX_FIELD_WIDTH];
					unsigned long long new_ds_addr;

					new_ds_addr = ds_addr + field_offset;
					strcpy(fname, sym_name);
					strcat(fname, "->");
					strcat(fname, field_name);
					sprintf(addr,"%x",new_ds_addr);
					//ds_addr = handle_long_datatypes(ptr, addr, sym_type, fname, strtype, ds_size);
					ret_ds_addr = handle_long_datatypes(ptr, addr, sym_type, fname, strtype, ds_size);
				}
				else if(strcmp(ptr,"double") == 0)
				{
					char addr[10];
					char fname[MAX_FIELD_WIDTH];
					unsigned long long new_ds_addr;

					new_ds_addr = ds_addr + field_offset;
					strcpy(fname, sym_name);
					strcat(fname, "->");
					strcat(fname, field_name);
					sprintf(addr,"%x",new_ds_addr);
					//ds_addr = handle_double_datatypes(ptr, addr, sym_type, fname, strtype, ds_size);
					ret_ds_addr = handle_double_datatypes(ptr, addr, sym_type, fname, strtype, ds_size);
				}
				else if(strcmp(ptr,"void") == 0)
				{
					char addr[10];
					char fname[MAX_FIELD_WIDTH];
					unsigned long long new_ds_addr;

					new_ds_addr = ds_addr + field_offset;
					strcpy(fname, sym_name);
					strcat(fname, "->");
					strcat(fname, field_name);
					sprintf(addr,"%x",new_ds_addr);
					//ds_addr = handle_void_datatypes(ptr, addr, sym_type, fname, strtype, ds_size);
					ret_ds_addr = handle_void_datatypes(ptr, addr, sym_type, fname, strtype, ds_size);
				}
				else if(strcmp(ptr,"union") == 0)
				{
					char addr[10];
					char fname[MAX_FIELD_WIDTH];
					unsigned long long new_ds_addr;

					new_ds_addr = ds_addr + field_offset;
					strcpy(fname, sym_name);
					strcat(fname, "->");
					strcat(fname, field_name);
					sprintf(addr,"%x",new_ds_addr);
					//ds_addr = handle_union_datatypes(ptr, addr, sym_type, fname, strtype, ds_size);
					ret_ds_addr = handle_union_datatypes(ptr, addr, sym_type, fname, strtype, ds_size);
				}
				else if(strcmp(ptr,"struct") == 0)
				{
					char addr[10];
					char fname[MAX_FIELD_WIDTH];
					unsigned long long new_ds_addr;

					new_ds_addr = ds_addr + field_offset;
					strcpy(fname, sym_name);
					strcat(fname, "->");
					strcat(fname, field_name);
					sprintf(addr,"%x",new_ds_addr);

					//ds_addr = handle_struct_datatypes(ptr, addr, sym_type, sym_name, strtype, ds_size);
					ret_ds_addr = handle_struct_datatypes(ptr, addr, sym_type, sym_name, strtype, ds_size);
				}


				fgets(buffer, MAX_LINE_INPUT_SIZE, fddefs_gen);
			}	
		}	
		//ret_ds_addr = ds_addr;
		fclose(fddefs_gen);
		fclose(fd_off);
	}
	else if(strstr(ptr,"*") != NULL)
	{
		//Either struct * or struct ** or struct * []
		if(strstr(ptr, "[") == NULL)
		{
			//It is struct pointer
			update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(void *));	
			//ret_ds_addr = ds_addr + sizeof(void *);
		}
		else if((strchr(ptr,'[')!= NULL) && (strchr(ptr, ']') != NULL))
		{
			//struct *[] - pointer array
			char * start_index, * end_index;
			char str_arr_index[5];
			int arr_index;

			start_index = index(ptr,'[');
			end_index = index(ptr, ']');
			int i=0;

			while(start_index < end_index)
			{
				++start_index;
				str_arr_index[i++] = *(char *)start_index;
			}
			str_arr_index[i + 1] ='\0';
			arr_index = atoi(str_arr_index);

			//Check here is array is two dimensional array
			if(strchr(end_index,'[') != NULL)
			{
				//Get the second index
				char str_arr_index2[5];

				i=0;
				start_index = end_index + 1;
				end_index = strchr(start_index,']');

				while(start_index < end_index)
				{
					++start_index;
					str_arr_index2[i++] = *(char *)start_index;
				}
				str_arr_index2[i + 1] ='\0';
				arr_index = arr_index * atoi(str_arr_index2);
			}

			for(i=0;i<arr_index;i++)
			{
				update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(void *));
				ds_addr = ds_addr +  sizeof(void *);
			}
			//ret_ds_addr = ds_addr;
		}
	}
	else if((strchr(ptr,'[')!= NULL) && (strchr(ptr, ']') != NULL))
	{
		//struct [] - struct array
		//Use mapped field information to repeat in array
		char * start_index, * end_index;
		char str_arr_index[5];
		char addr[10];
		char strtype[MAX_FIELD_WIDTH];
		char temptype[MAX_FIELD_WIDTH];

		start_index = index(ptr,'[');
		end_index = index(ptr, ']');
		int i=0;
		int arr_index;
		int struct_begin_index, struct_end_index;
		int struct_size;
		unsigned long long struct_base_addr;
		unsigned long long prev_ds_addr;


		while(start_index < end_index)
		{
			++start_index;
			str_arr_index[i++] = *(char *)start_index;
		}
		str_arr_index[i + 1] ='\0';
		arr_index = atoi(str_arr_index);

		//Check here is array is two dimensional array
		if(strchr(end_index,'[') != NULL)
		{
			//Get the second index
			char str_arr_index2[5];
			
			i=0;
			start_index = end_index + 1;
			end_index = strchr(start_index,']');	
			
			while(start_index < end_index)
			{
					++start_index;
					str_arr_index2[i++] = *(char *)start_index;
			}
			str_arr_index2[i + 1] ='\0';
			arr_index = arr_index * atoi(str_arr_index2);
		}

		struct_begin_index = current_staticmem_location_index;
		sprintf(addr,"%x",ds_addr);

		strcpy(strtype, ds_type);
		strcpy(temptype, ds_type);
		for(i=0; i<strlen(strtype); i++)
		{
			if(strtype[i]=='[')
			{
				temptype[i]='\0';
				strtype[i]='\0';
			}
		}
		ptr = strtok(temptype," "); // This is bcos function below calls strtok with a NULL */
		
		prev_ds_addr = ds_addr;
		printf("prev ds_addr =0x%x\n", prev_ds_addr);
		ds_addr = handle_struct_datatypes(ptr, addr, sym_type, sym_name, strtype, ds_size);
		printf("ret ds_addr = 0x%x\n", ds_addr);
		//handle_struct_datatypes(ptr, addr, sym_type, sym_name, strtype, ds_size);

		struct_end_index = current_staticmem_location_index;
		//Do it one less time than the total number of elements in the array
		// as one call above is already made

		//struct_size = ds_addr - prev_ds_addr; 
		struct_size = ds_size / arr_index;

		//struct_base_addr = ds_addr;
		struct_base_addr = strtoll(static_memory_addr[struct_begin_index], NULL,16) + struct_size;

		for(i=0;i<(arr_index - 1);i++)
		{
			//ds_addr = ds_addr +  sizeof(char);
			int j;


		//printf("struct base addr= 0x%x\n", struct_base_addr);
			for(j=struct_begin_index; j<struct_end_index; j++)
			{	
				char struct_field_name[MAX_FIELD_WIDTH];
				char struct_field_type[MAX_FIELD_WIDTH];
				int struct_field_size;
				unsigned long long struct_field_addr;
				int field_offset;

				field_offset = strtoll(static_memory_addr[j],NULL,16) - strtoll(static_memory_addr[struct_begin_index], NULL,16); 
				
				strcpy(struct_field_name, static_memory_name[j]);
				strcpy(struct_field_type, static_memory_type[j]);
				struct_field_size = static_memory_size[j];	

				struct_field_addr = struct_base_addr + field_offset;

				//printf("struct field addr = 0x%x\n", struct_field_addr);
				update_static_mem_array(struct_field_addr, struct_field_name, struct_field_type, struct_field_size);
			}
			//ds_addr = ds_addr + struct_size; 
			struct_base_addr= struct_base_addr + struct_size;
		}
		//ret_ds_addr = ds_addr;
	}
	
	return(ret_ds_addr);
}

unsigned long long handle_char_datatypes(char * ptr, char * sym_addr, char sym_type, char * sym_name,
                        char * ds_type, int ds_size)
{
	unsigned long long ds_addr;
	unsigned long long ret_ds_addr;

 	//This type may be either char / char * / char ** /
	// char [] / char [][] / char volatile
	//printf("%s %c %s %s %d\n", sym_addr, sym_type, sym_name, ds_type, ds_size);
	ds_addr = strtoll(sym_addr,NULL,16);
	ptr = strtok(NULL," ");

	if((ptr != NULL) && ((strcmp(ptr,"volatile") == 0) || (strcmp(ptr,"const") == 0)))
	{
		ptr = strtok(NULL," ");
	}

	if(ptr == NULL)
	{
		//This is a char
		update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(char));
		ret_ds_addr = ds_addr + sizeof(char);
	}
	else if(strstr(ptr,"*") != NULL)
	{
		//Either char * or char ** or char * []
		if(strstr(ptr, "[") == NULL)
		{
			//It is char pointer
			update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(char *));	
			ret_ds_addr = ds_addr + sizeof(char *);
		}
		else if((strchr(ptr,'[')!= NULL) && (strchr(ptr, ']') != NULL))
		{
			//char * [] - pointer array
			char * start_index, * end_index;
			char str_arr_index[5];
			int arr_index;

			start_index = index(ptr,'[');
			end_index = index(ptr, ']');
			int i=0;

			while(start_index < end_index)
			{
				++start_index;
				str_arr_index[i++] = *(char *)start_index;
			}
			str_arr_index[i + 1] ='\0';
			arr_index = atoi(str_arr_index);

			//Check here is array is two dimensional array
			if(strchr(end_index,'[') != NULL)
			{
				//Get the second index
				char str_arr_index2[5];

				i=0;
				start_index = end_index + 1;
				end_index = strchr(start_index,']');

				while(start_index < end_index)
				{
					++start_index;
					str_arr_index2[i++] = *(char *)start_index;
				}
				str_arr_index2[i + 1] ='\0';
				arr_index = arr_index * atoi(str_arr_index2);
			}

			for(i=0;i<arr_index;i++)
			{
				update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(char *));
				ds_addr = ds_addr +  sizeof(char *);
			}
			ret_ds_addr = ds_addr; 
		}
	}
	else if((strchr(ptr,'[')!= NULL) && (strchr(ptr, ']') != NULL))
	{
		//char [] - character array
		char * start_index, * end_index;
		char str_arr_index[5];
		start_index = index(ptr,'[');
		end_index = index(ptr, ']');
		int i=0;
		int arr_index;


		while(start_index < end_index)
		{
			++start_index;
			str_arr_index[i++] = *(char *)start_index;
		}
		str_arr_index[i + 1] ='\0';
		arr_index = atoi(str_arr_index);

		//Check here is array is two dimensional array
		if(strchr(end_index,'[') != NULL)
		{
			//Get the second index
			char str_arr_index2[5];
			
			i=0;
			start_index = end_index + 1;
			end_index = strchr(start_index,']');	
			
			while(start_index < end_index)
			{
					++start_index;
					str_arr_index2[i++] = *(char *)start_index;
			}
			str_arr_index2[i + 1] ='\0';
			arr_index = arr_index * atoi(str_arr_index2);
		}

		for(i=0;i<arr_index;i++)
		{
			update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(char));
			ds_addr = ds_addr +  sizeof(char);
		}
		ret_ds_addr = ds_addr; 
	}
	
	return(ret_ds_addr);
}

unsigned long long handle_double_datatypes(char * ptr, char * sym_addr, char sym_type, char * sym_name,
                        char * ds_type, int ds_size)
{
	unsigned long long ds_addr;
	unsigned long long ret_ds_addr;

 	//This type may be either char / char * / char ** /
	// char [] / char [][] / char volatile
	//printf("%s %c %s %s %d\n", sym_addr, sym_type, sym_name, ds_type, ds_size);
	ds_addr = strtoll(sym_addr,NULL,16);
	ptr = strtok(NULL," ");

	if((ptr != NULL) && ((strcmp(ptr,"volatile") == 0) || (strcmp(ptr,"const") == 0)))
	{
		ptr = strtok(NULL," ");
	}

	if(ptr == NULL)
	{
		//This is a char
		update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(double));
		ret_ds_addr = ds_addr + sizeof(double);
	}
	else if(strstr(ptr,"*") != NULL)
	{
		//Either char * or char ** or char * []
		if(strstr(ptr, "[") == NULL)
		{
			//It is char pointer
			update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(double *));	
			ret_ds_addr = ds_addr + sizeof(double *);
		}
		else if((strchr(ptr,'[')!= NULL) && (strchr(ptr, ']') != NULL))
		{
			//char * [] - pointer array
			char * start_index, * end_index;
			char str_arr_index[5];
			int arr_index;

			start_index = index(ptr,'[');
			end_index = index(ptr, ']');
			int i=0;

			while(start_index < end_index)
			{
				++start_index;
				str_arr_index[i++] = *(char *)start_index;
			}
			str_arr_index[i + 1] ='\0';
			arr_index = atoi(str_arr_index);

			//Check here is array is two dimensional array
			if(strchr(end_index,'[') != NULL)
			{
				//Get the second index
				char str_arr_index2[5];

				i=0;
				start_index = end_index + 1;
				end_index = strchr(start_index,']');

				while(start_index < end_index)
				{
					++start_index;
					str_arr_index2[i++] = *(char *)start_index;
				}
				str_arr_index2[i + 1] ='\0';
				arr_index = arr_index * atoi(str_arr_index2);
			}

			for(i=0;i<arr_index;i++)
			{
				update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(double *));
				ds_addr = ds_addr +  sizeof(double *);
			}
			ret_ds_addr = ds_addr; 
		}
	}
	else if((strchr(ptr,'[')!= NULL) && (strchr(ptr, ']') != NULL))
	{
		//char [] - character array
		char * start_index, * end_index;
		char str_arr_index[5];
		start_index = index(ptr,'[');
		end_index = index(ptr, ']');
		int i=0;
		int arr_index;


		while(start_index < end_index)
		{
			++start_index;
			str_arr_index[i++] = *(char *)start_index;
		}
		str_arr_index[i + 1] ='\0';
		arr_index = atoi(str_arr_index);

		//Check here is array is two dimensional array
		if(strchr(end_index,'[') != NULL)
		{
			//Get the second index
			char str_arr_index2[5];
			
			i=0;
			start_index = end_index + 1;
			end_index = strchr(start_index,']');	
			
			while(start_index < end_index)
			{
					++start_index;
					str_arr_index2[i++] = *(char *)start_index;
			}
			str_arr_index2[i + 1] ='\0';
			arr_index = arr_index * atoi(str_arr_index2);
		}

		for(i=0;i<arr_index;i++)
		{
			update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(double));
			ds_addr = ds_addr +  sizeof(double);
		}
		ret_ds_addr = ds_addr; 
	}
	
	return(ret_ds_addr);
}

unsigned long long handle_short_datatypes(char * ptr, char * sym_addr, char sym_type, char * sym_name,
                        char * ds_type, int ds_size)
{
	unsigned long long ds_addr;
	unsigned long long ret_ds_addr;

 	//This type may be either int / int  * / int ** /
	// int [] / int [][] / int volatile
	//printf("%s %c %s %s %d\n", sym_addr, sym_type, sym_name, ds_type, ds_size);
	ds_addr = strtoll(sym_addr,NULL,16);
	ptr = strtok(NULL," ");

	if((ptr != NULL) && ((strcmp(ptr,"volatile") == 0) || (strcmp(ptr,"const") == 0)))
	{
		ptr = strtok(NULL," ");
	}

	if(ptr == NULL)
	{
		//This is a int 
		update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(short));
		ret_ds_addr = ds_addr + sizeof(short);
	}
	else if(strstr(ptr,"*") != NULL)
	{
		//Either int * or int ** or int * []
		if(strstr(ptr, "[") == NULL)
		{
			//It is int pointer
			update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(short *));	
			ret_ds_addr = ds_addr + sizeof(short *);
		}
		else if((strchr(ptr,'[')!= NULL) && (strchr(ptr, ']') != NULL))
		{
			//int * [] - pointer array
			char * start_index, * end_index;
			char str_arr_index[5];
			int arr_index;

			start_index = index(ptr,'[');
			end_index = index(ptr, ']');
			int i=0;

			while(start_index < end_index)
			{
				++start_index;
				str_arr_index[i++] = *(char *)start_index;
			}
			str_arr_index[i + 1] ='\0';
			arr_index = atoi(str_arr_index);

			//Check here is array is two dimensional array
			if(strchr(end_index,'[') != NULL)
			{
				//Get the second index
				char str_arr_index2[5];

				i=0;
				start_index = end_index + 1;
				end_index = strchr(start_index,']');

				while(start_index < end_index)
				{
					++start_index;
					str_arr_index2[i++] = *(char *)start_index;
				}
				str_arr_index2[i + 1] ='\0';
				arr_index = arr_index * atoi(str_arr_index2);
			}

			for(i=0;i<arr_index;i++)
			{
				update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(short *));
				ds_addr = ds_addr +  sizeof(short *);
			}
			ret_ds_addr = ds_addr;
		}
	}
	else if((strchr(ptr,'[')!= NULL) && (strchr(ptr, ']') != NULL))
	{
		//int [] - character array
		char * start_index, * end_index;
		char str_arr_index[5];
		start_index = index(ptr,'[');
		end_index = index(ptr, ']');
		int i=0;
		int arr_index;


		while(start_index < end_index)
		{
			++start_index;
			str_arr_index[i++] = *(char *)start_index;
		}
		str_arr_index[i + 1] ='\0';
		arr_index = atoi(str_arr_index);

		//Check here is array is two dimensional array
		if(strchr(end_index,'[') != NULL)
		{
			//Get the second index
			char str_arr_index2[5];
			
			i=0;
			start_index = end_index + 1;
			end_index = strchr(start_index,']');	
			
			while(start_index < end_index)
			{
					++start_index;
					str_arr_index2[i++] = *(char *)start_index;
			}
			str_arr_index2[i + 1] ='\0';
			arr_index = arr_index * atoi(str_arr_index2);
		}

		for(i=0;i<arr_index;i++)
		{
			update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(short));
			ds_addr = ds_addr +  sizeof(short);
		}
		ret_ds_addr = ds_addr;
	}
	return(ret_ds_addr);
}

unsigned long long handle_int_datatypes(char * ptr, char * sym_addr, char sym_type, char * sym_name,
                        char * ds_type, int ds_size)
{
	unsigned long long ds_addr;
	unsigned long long ret_ds_addr;

 	//This type may be either int / int  * / int ** /
	// int [] / int [][] / int volatile
	//printf("%s %c %s %s %d\n", sym_addr, sym_type, sym_name, ds_type, ds_size);
	ds_addr = strtoll(sym_addr,NULL,16);
	if(strstr(ds_type, "enum") != NULL)
	{
		//An extra strtok is required here as enum if defined as
		// enum xxx
		ptr = strtok(NULL," ");
	}

	ptr = strtok(NULL," ");
	if((ptr != NULL) && ((strcmp(ptr,"volatile") == 0) || (strcmp(ptr,"const") == 0)))
	{
		ptr = strtok(NULL," ");
	}
	
	if(ptr == NULL)
	{
		//This is a int 
		update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(int));
		ret_ds_addr = ds_addr + sizeof(int);
	}
	else if(strstr(ptr,"*") != NULL)
	{
		//Either int * or int ** or int * []
		if(strstr(ptr, "[") == NULL)
		{
			//It is int pointer
			update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(int *));	
			ret_ds_addr = ds_addr + sizeof(int *);
		}
		else if((strchr(ptr,'[')!= NULL) && (strchr(ptr, ']') != NULL))
		{
			//int * [] - pointer array
			char * start_index, * end_index;
			char str_arr_index[5];
			int arr_index;

			start_index = index(ptr,'[');
			end_index = index(ptr, ']');
			int i=0;

			while(start_index < end_index)
			{
				++start_index;
				str_arr_index[i++] = *(char *)start_index;
			}
			str_arr_index[i + 1] ='\0';
			arr_index = atoi(str_arr_index);

			//Check here is array is two dimensional array
			if(strchr(end_index,'[') != NULL)
			{
				//Get the second index
				char str_arr_index2[5];

				i=0;
				start_index = end_index + 1;
				end_index = strchr(start_index,']');

				while(start_index < end_index)
				{
					++start_index;
					str_arr_index2[i++] = *(char *)start_index;
				}
				str_arr_index2[i + 1] ='\0';
				arr_index = arr_index * atoi(str_arr_index2);
			}

			for(i=0;i<arr_index;i++)
			{
				update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(int *));
				ds_addr = ds_addr +  sizeof(int *);
			}
		    ret_ds_addr = ds_addr;
		}
	}
	else if((strchr(ptr,'[')!= NULL) && (strchr(ptr, ']') != NULL))
	{
		//int [] - character array
		char * start_index, * end_index;
		char str_arr_index[5];
		start_index = index(ptr,'[');
		end_index = index(ptr, ']');
		int i=0;
		int arr_index;


		while(start_index < end_index)
		{
			++start_index;
			str_arr_index[i++] = *(char *)start_index;
		}
		str_arr_index[i + 1] ='\0';
		arr_index = atoi(str_arr_index);

		//Check here is array is two dimensional array
		if(strchr(end_index,'[') != NULL)
		{
			//Get the second index
			char str_arr_index2[5];
			
			i=0;
			start_index = end_index + 1;
			end_index = strchr(start_index,']');	
			
			while(start_index < end_index)
			{
					++start_index;
					str_arr_index2[i++] = *(char *)start_index;
			}
			str_arr_index2[i + 1] ='\0';
			arr_index = arr_index * atoi(str_arr_index2);
		}

		for(i=0;i<arr_index;i++)
		{
			update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(int));
			ds_addr = ds_addr +  sizeof(int);
		}
		ret_ds_addr = ds_addr;
	}
	return(ret_ds_addr);	
}

unsigned long long handle_long_datatypes(char * ptr, char * sym_addr, char sym_type, char * sym_name,
                        char * ds_type, int ds_size)
{
	unsigned long long ds_addr;
	unsigned long long ret_ds_addr;
	short longlong = 0;

 	//This type may be either long/ long * / long ** /
	// long [] / long [][] / long volatile
	//printf("in handle_data types %s %c %s %s %d\n", sym_addr, sym_type, sym_name, ds_type, ds_size);
	ds_addr = strtoll(sym_addr,NULL,16);
	ptr = strtok(NULL," ");

	if((ptr != NULL) && ((strcmp(ptr,"volatile") == 0) || (strcmp(ptr,"const") == 0)))
	{
		ptr = strtok(NULL," ");
	}

	if(ptr == NULL)
	{
		//This is a long 
		update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(long));
		ret_ds_addr = ds_addr + sizeof(long);
	}
	else if(strcmp(ptr,"long") == 0)
	{	
		ptr = strtok(NULL, " ");
		if(ptr == NULL)
		{
			//This is a long long data type
			update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(long long));
			ret_ds_addr = ds_addr + sizeof(long long);
		}
		longlong=1;
	}

	if(ptr != NULL)
	{
		if(strstr(ptr,"*") != NULL)
		{
			//Either char * or char ** or char * []
			if(strstr(ptr, "[") == NULL)
			{
				if(longlong == 1)
				{
					update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(long long *));	
					ret_ds_addr = ds_addr + sizeof(long long *);
				}
				else
				{
					update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(long *));	
					ret_ds_addr = ds_addr + sizeof(long *);
				}

			}
			else if((strchr(ptr,'[')!= NULL) && (strchr(ptr, ']') != NULL))
			{
				//long * [] - pointer array
				char * start_index, * end_index;
				char str_arr_index[5];
				int arr_index;

				start_index = index(ptr,'[');
				end_index = index(ptr, ']');
				int i=0;

				while(start_index < end_index)
				{
					++start_index;
					str_arr_index[i++] = *(char *)start_index;
				}
				str_arr_index[i + 1] ='\0';
				arr_index = atoi(str_arr_index);

				//Check here is array is two dimensional array
				if(strchr(end_index,'[') != NULL)
				{
					//Get the second index
					char str_arr_index2[5];

					i=0;
					start_index = end_index + 1;
					end_index = strchr(start_index,']');

					while(start_index < end_index)
					{
							++start_index;
							str_arr_index2[i++] = *(char *)start_index;
					}
					str_arr_index2[i + 1] ='\0';
					arr_index = arr_index * atoi(str_arr_index2);
				}

				for(i=0;i<arr_index;i++)
				{
					if(longlong == 1)
					{
						update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(long long *));
						ds_addr = ds_addr +  sizeof(long long *);
					}
					else
					{
						update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(long *));
						ds_addr = ds_addr +  sizeof(long *);
					}
				}
				ret_ds_addr = ds_addr;
			}
		}
		else if((strchr(ptr,'[')!= NULL) && (strchr(ptr, ']') != NULL))
		{
			//long [] - array
			char * start_index, * end_index;
			char str_arr_index[5];
			start_index = index(ptr,'[');
			end_index = index(ptr, ']');
			int i=0;
			int arr_index;


			while(start_index < end_index)
			{
				++start_index;
				str_arr_index[i++] = *(char *)start_index;
			}
			str_arr_index[i + 1] ='\0';
			arr_index = atoi(str_arr_index);

			//Check here is array is two dimensional array
			if(strchr(end_index,'[') != NULL)
			{
				//Get the second index
				char str_arr_index2[5];

				i=0;
				start_index = end_index + 1;
				end_index = strchr(start_index,']');	

				while(start_index < end_index)
				{
					++start_index;
					str_arr_index2[i++] = *(char *)start_index;
				}
				str_arr_index2[i + 1] ='\0';
				arr_index = arr_index * atoi(str_arr_index2);
			}

			for(i=0;i<arr_index;i++)
			{
				if(longlong == 1)
				{
					update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(long long));
					ds_addr = ds_addr +  sizeof(long long);
				}
				else
				{
					update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(long));
					ds_addr = ds_addr +  sizeof(long);
				}
			}
			ret_ds_addr = ds_addr;
		}
	}	
	return(ret_ds_addr);
}

unsigned long long handle_void_datatypes(char * ptr, char * sym_addr, char sym_type, char * sym_name,
                        char * ds_type, int ds_size)
{
	unsigned long long ds_addr;
	unsigned long long ret_ds_addr;

 	//This type may be either char / char * / char ** /
	// char [] / char [][] / char volatile
	//printf("%s %c %s %s %d\n", sym_addr, sym_type, sym_name, ds_type, ds_size);
	ds_addr = strtoll(sym_addr,NULL,16);
	ptr = strtok(NULL," ");

	if((ptr != NULL) && ((strcmp(ptr,"volatile") == 0) || (strcmp(ptr,"const") == 0)))
	{
		ptr = strtok(NULL," ");
	}

	if(ptr == NULL)
	{
		//This is a char
		update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(void));
		ret_ds_addr = ds_addr + sizeof(void);
	}
	else if(strstr(ptr,"*") != NULL)
	{
		//Either char * or char ** or char * []
		if(strstr(ptr, "[") == NULL)
		{
			//It is char pointer
			update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(void *));	
			ret_ds_addr = ds_addr + sizeof(void *);
		}
		else if((strchr(ptr,'[')!= NULL) && (strchr(ptr, ']') != NULL))
		{
			//char * [] - pointer array
			char * start_index, * end_index;
			char str_arr_index[5];
			int arr_index;

			start_index = index(ptr,'[');
			end_index = index(ptr, ']');
			int i=0;

			while(start_index < end_index)
			{
				++start_index;
				str_arr_index[i++] = *(char *)start_index;
			}
			str_arr_index[i + 1] ='\0';
			arr_index = atoi(str_arr_index);

			//Check here is array is two dimensional array
			if(strchr(end_index,'[') != NULL)
			{
				//Get the second index
				char str_arr_index2[5];

				i=0;
				start_index = end_index + 1;
				end_index = strchr(start_index,']');

				while(start_index < end_index)
				{
					++start_index;
					str_arr_index2[i++] = *(char *)start_index;
				}
				str_arr_index2[i + 1] ='\0';
				arr_index = arr_index * atoi(str_arr_index2);
			}

			for(i=0;i<arr_index;i++)
			{
				update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(void *));
				ds_addr = ds_addr +  sizeof(void *);
			}
			ret_ds_addr = ds_addr;
		}
	}
	else if((strchr(ptr,'[')!= NULL) && (strchr(ptr, ']') != NULL))
	{
		//char [] - character array
		char * start_index, * end_index;
		char str_arr_index[5];
		start_index = index(ptr,'[');
		end_index = index(ptr, ']');
		int i=0;
		int arr_index;


		while(start_index < end_index)
		{
			++start_index;
			str_arr_index[i++] = *(char *)start_index;
		}
		str_arr_index[i + 1] ='\0';
		arr_index = atoi(str_arr_index);

		//Check here is array is two dimensional array
		if(strchr(end_index,'[') != NULL)
		{
			//Get the second index
			char str_arr_index2[5];
			
			i=0;
			start_index = end_index + 1;
			end_index = strchr(start_index,']');	
			
			while(start_index < end_index)
			{
					++start_index;
					str_arr_index2[i++] = *(char *)start_index;
			}
			str_arr_index2[i + 1] ='\0';
			arr_index = arr_index * atoi(str_arr_index2);
		}

		for(i=0;i<arr_index;i++)
		{
			update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(void));
			ds_addr = ds_addr +  sizeof(void);
		}
		ret_ds_addr = ds_addr;
	}
	return(ret_ds_addr);
}

unsigned long long  handle_union_datatypes(char * ptr, char * sym_addr, char sym_type, char * sym_name,
                        char * ds_type, int ds_size)
{
	unsigned long long ds_addr;
	unsigned long long ret_ds_addr;

 	//This type may be either char / char * / char ** /
	// union [] / union [][] / union volatile
	//printf("%s %c %s %s %d\n", sym_addr, sym_type, sym_name, ds_type, ds_size);
	ds_addr = strtoll(sym_addr,NULL,16);
	ptr = strtok(NULL," ");
	ptr = strtok(NULL," ");
	if(ptr == NULL)
	{
		//This is a union 
		update_static_mem_array(ds_addr, sym_name, ds_type, ds_size);
		ret_ds_addr = ds_addr + ds_size;
	}
	else if(strstr(ptr,"*") != NULL)
	{
		//Either char * or char ** or char * []
		if(strstr(ptr, "[") == NULL)
		{
			//It is char pointer
			update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(void *));	
			ret_ds_addr = ds_addr + sizeof(void *);
		}
		else if((strchr(ptr,'[')!= NULL) && (strchr(ptr, ']') != NULL))
		{
			//union * [] - pointer array
			char * start_index, * end_index;
			char str_arr_index[5];
			int arr_index;

			start_index = index(ptr,'[');
			end_index = index(ptr, ']');
			int i=0;

			while(start_index < end_index)
			{
				++start_index;
				str_arr_index[i++] = *(char *)start_index;
			}
			str_arr_index[i + 1] ='\0';
			arr_index = atoi(str_arr_index);

			//Check here is array is two dimensional array
			if(strchr(end_index,'[') != NULL)
			{
				//Get the second index
				char str_arr_index2[5];

				i=0;
				start_index = end_index + 1;
				end_index = strchr(start_index,']');

				while(start_index < end_index)
				{
					++start_index;
					str_arr_index2[i++] = *(char *)start_index;
				}
				str_arr_index2[i + 1] ='\0';
				arr_index = arr_index * atoi(str_arr_index2);
			}

			for(i=0;i<arr_index;i++)
			{
				update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(void *));
				ds_addr = ds_addr +  sizeof(void *);
			}
			ret_ds_addr = ds_addr;
		}
	}
	else if((strchr(ptr,'[')!= NULL) && (strchr(ptr, ']') != NULL))
	{
		//char [] - character array
		char * start_index, * end_index;
		char str_arr_index[5];
		start_index = index(ptr,'[');
		end_index = index(ptr, ']');
		int i=0;
		int arr_index;


		while(start_index < end_index)
		{
			++start_index;
			str_arr_index[i++] = *(char *)start_index;
		}
		str_arr_index[i + 1] ='\0';
		arr_index = atoi(str_arr_index);

		//Check here is array is two dimensional array
		if(strchr(end_index,'[') != NULL)
		{
			//Get the second index
			char str_arr_index2[5];
			
			i=0;
			start_index = end_index + 1;
			end_index = strchr(start_index,']');	
			
			while(start_index < end_index)
			{
					++start_index;
					str_arr_index2[i++] = *(char *)start_index;
			}
			str_arr_index2[i + 1] ='\0';
			arr_index = arr_index * atoi(str_arr_index2);
		}

		for(i=0;i<arr_index;i++)
		{
			update_static_mem_array(ds_addr, sym_name, ds_type, ds_size);
			ds_addr = ds_addr +  ds_size;
		}
		ret_ds_addr = ds_addr;
	}
	return(ret_ds_addr);
}

unsigned long long handle__Bool_datatypes(char * ptr, char * sym_addr, char sym_type, char * sym_name,
                        char * ds_type, int ds_size)
{
	unsigned long long ds_addr;
	unsigned long long ret_ds_addr;

 	//This type can be _Bool

	//printf("%s %c %s %s %d\n", sym_addr, sym_type, sym_name, ds_type, ds_size);
	ds_addr = strtoll(sym_addr,NULL,16);
	ptr = strtok(NULL," ");
	ptr = strtok(NULL," ");
	if(ptr == NULL)
	{
		//This is a _Bool
		update_static_mem_array(ds_addr, sym_name, ds_type, sizeof(_Bool));
		ret_ds_addr = ds_addr + sizeof(_Bool);
	}
	return(ret_ds_addr);
}

void update_static_mem_array(unsigned long ds_addr, char * sym_name, char * sym_type, short ds_size)
{
	char str_ds_addr[10];
	char * strtype;

	sprintf(str_ds_addr,"%x",ds_addr);	

	printf("Updating [%s][%s] %d\n", str_ds_addr, sym_name,current_staticmem_location_index);
	strcpy(static_memory_addr[current_staticmem_location_index],str_ds_addr);
	strcpy(static_memory_name[current_staticmem_location_index],sym_name);

	if(function_ptr(sym_type))
	{
    	strcpy(static_memory_type[current_staticmem_location_index],sym_type);
    	static_memory_size[current_staticmem_location_index] = sizeof(void *); 
    	current_staticmem_location_index++; 
		return;
	}

	/*Here if sym_type is a typedef, resolve to primitve type */
	if(strcmp(sym_name,"mtrr_fops->read") == 0)
	{
		printf("func ptr type=%s\n", sym_type);
		printf("is a func ptr =%d\n", function_ptr(sym_type));
		exit(-1);
	}

	//printf("2992 before resolve in update_static_mem_array symtype: %s\n",sym_type);
	strtype = resolve_typedef(sym_type);

	if(strtype != NULL)
	{
		char tmpstr[MAX_FIELD_WIDTH];
		char finalstr[MAX_FIELD_WIDTH];

		//After resolving, check again if it is a function ptr
		if(function_ptr(strtype))
		{
    		strcpy(static_memory_type[current_staticmem_location_index],strtype);
    		static_memory_size[current_staticmem_location_index] = sizeof(void *); 
    		current_staticmem_location_index++; 
			return;
		}
		strcpy(tmpstr, sym_type);	
		if((strstr(tmpstr,"*") != NULL) || (strstr(tmpstr,"[") != NULL))
		{
			char * ptr;

			ptr = strtok(tmpstr," ");
			ptr = strtok(NULL, " ");

			strcpy(finalstr,strtype);
			strcat(finalstr,ptr);
		}
		else
		{
			strcpy(finalstr,strtype);
		}
		strcpy(static_memory_type[current_staticmem_location_index],finalstr);
	}
	else
	{
    	strcpy(static_memory_type[current_staticmem_location_index],sym_type);
	}

    static_memory_size[current_staticmem_location_index] = ds_size; 
    current_staticmem_location_index++; 
}

char * rtrim(char * str)
{
	int i;

	for(i = (strlen(str) - 1); i >= 0; i--)
	{
		char c = *(char *)(str + i);

		if((c == ' ') || (c == '\0') || (c == '\n'))
		{
			*(char *)(str + i) = '\0';
		}
		else 
		{
			break;
		}
	}
	return(str);
}

/* 
 * JEFF change
 * ltrim was adding \0 to front. This creates
 * a string of length 0.
 *
 * Segment fault was being caused because incoming str
 * defined as a static string [].
 *
char * ltrim(char * str)
{
	int i;

	for(i =0; i < strlen(str); i++)
	{
		char c = *(char *)(str + i);

		if((c == ' ') || (c == '\0'))
		{
			*(char *)(str + i) = '\0';
		}
		else 
		{
			break;
		}
	}
	return(str);
}
*/

char * ltrim(char * str)
{
	int i=0;

	while(i < strlen(str)){
	
		if((str[0] == ' ') || (str[0] == '\0'))
			str++;
		i++;
	}

	return(str);
}

char * trim(char * str)
{
	return(rtrim(ltrim(str)));
}

/* From a given string, extracts the nth field 
   buffer - The string that is to be searched for the field
   field_num - is the field number to be extracted 

   Return Values: returns the extracted field if successful
				  else returns NULL
*/
char * get_field_info(char * buffer, short field_num)
{
	char l_delimiter =LEFT_FIELD_DELIMITER;
	char r_delimiter =RIGHT_FIELD_DELIMITER;
	short field_counter =0;
	char * ret_buf;
	short start_copying = 0, copied =0;
	int j=0;
	int i;

	ret_buf = (char *)malloc(MAX_LINE_INPUT_SIZE);
	for(i=0; i< strlen(buffer); i++)
	{
		if(buffer[i] == l_delimiter)
		{	
			field_counter++;

			if(field_counter == field_num) //This is the field to return	
			{
				start_copying = 1;
			}
		}
		else if(buffer[i] == r_delimiter)
		{	
			if(field_counter == field_num)
			{
				assert(start_copying == 1);
				*(ret_buf + j) = '\0';
				copied = 1;
				break;
			}	
		}
		else
		{
			if(start_copying == 1)
			{
				*(char *)(ret_buf + j) = buffer[i];
				
				j++;
			}
		}
	}
	if(copied == 1)
		return(ret_buf);
	else
		return(NULL);
}


short is_typedef(char * str)
{
    if(strstr(str,"int") != NULL)
    {
        return 0;
    }
    else if(strstr(str,"long") != NULL)
    {
        return 0;
    }
    else if(strstr(str,"short") != NULL)
    {
        return 0;
    }
    else if(strstr(str,"void") != NULL)
    {
        return 0;
    }
    else if(strstr(str,"double") != NULL)
    {
        return 0;
    }
    else if(strstr(str,"void") != NULL)
    {
        return 0;
    }
    else if(strstr(str,"char") != NULL)
    {
        return 0;
    }
    else if(strstr(str,"struct") != NULL)
    {
        return 0;
    }
    else if(strstr(str,"union") != NULL)
    {
        return 0;
    }
    else if(strstr(str,"enum") != NULL)
    {
        return 0;
    }
    else
    {
        return 1;
    }
}
