/* This is the header file for monitor.c */
#include "global.h"
                                                                                                                                               
int min_buf_size;
int count_sends = 0;
int todo, exit_now=0;
unsigned char dmadata_buffer[SLAB_SIZE];
char buffer[BUFFER_LEN];
char shabuffer[MB][SECURE_HASH_BUFFER_LEN];
int MSMT_ROUNDS;
FILE * fd_alerts;
FILE * fd_stats;
FILE * inv_alerts;
FILE * fd_dangle;
int detection=0;
int total_objects = 0;
int total_symbols = 0;
int obj_func_ptr=0;
int total_func_ptr =0;
bool prefetch_phase = true;
int max_qsize = 0;
int null_roots = 0;
int skipped_nodes = 0;
int inconsistent_cnt =0;
int same_object_cnt =0;
bool start_logging = true;
                                                                                                                                               
struct timeval start,end;
struct timeval scan_start,scan_end;
struct timespec startsha, endsha;
                                                                                                                                               
unsigned long total_page_frames;
char learn_from_file[FILENAME_SIZE];
char invmap_from_file[FILENAME_SIZE];

/* New global variables */
/* Stores index of current symbol to begin looking from in the static_symbol vector.
   This takes advantage of the fact that the System.map file is in sorted order
   Reduces time in looking for the symbol from the beginning of the vector 
   every time a new page is fetched 
*/
int STATIC_SYMBOL_CURRENT = 0; 
vector<symbol_t> static_symbol;
multimap<unsigned long long, int> static_symbol_map;

vector<vector <unsigned char> > static_pages;

vector<int> init_roots;

map<string, definition_t> def_map;
map<unsigned long long, page_t> page_map;
//Converted from map to multimap only for efficiency purposes
map<unsigned long long, char> visited;

//Stores learnt static invariants
map<unsigned long long, char> learnt_static_invariants;

//This map stores values of primitive fields
multimap<unsigned long long, symbol_t> dynamic_symbol;

//This map stores composite object information
//Converted from map to multimap only for efficiency purposes
map<unsigned long long, entry_t> dynamic_objects;

/* Map to store object statistics */
map<string, int> type_stats;

/* Map to store invariant list */
//class invariants
map<string,vector<inv_ent_t> > invariants;

//object invariants
map<string,vector<inv_ent_t> > object_invariants;

//List invariants
vector<inv_ent_t> list_invariants;

//Linked list values stored in memory for invariant checking
map<string,vector<unsigned long long> > listvals;

                                                                                                                                               
/*Stores the object name and field values to pass to verifier */
vector<fld_ent_t> current_obj;

/* JEFF ADDITIONS */
/* Variables below are used for virtual address translation and Xen additions */
uint32_t dom; 
int translate;
unsigned int virt_addr;

/* memory map for guest domain */
unsigned char *memory_map;
/* Live mapping of the table mapping each PFN to its current MFN. */
static xen_pfn_t *live_p2m;
static xen_pfn_t *live_m2p;
unsigned long p2m_size;

/* flag for shadow scan or normal */
int shadow,notify,num_pages,time_between;
queue<entry_t>dirty_roots; 
multimap<unsigned long long, entry_t> dynamic_pfn_map;
map<string,entry_t> dynamic_path_map;

unsigned long *bitmap;

int total_checks;

/* macros for bitmap */
#define BITS_PER_LONG (sizeof(unsigned long) * 8)
#define BITS_TO_LONGS(bits) (((bits)+BITS_PER_LONG-1)/BITS_PER_LONG)
#define BITMAP_SIZE   (BITS_TO_LONGS(p2m_size) * sizeof(unsigned long))

#define BITMAP_ENTRY(_nr,_bmap) \
   ((volatile unsigned long *)(_bmap))[(_nr)/BITS_PER_LONG]

#define BITMAP_SHIFT(_nr) ((_nr) % BITS_PER_LONG)

#define PAGE_SHIFT 12

#define ROUNDUP(_x,_w) (((unsigned long)(_x)+(1UL<<(_w))-1) & ~((1UL<<(_w))-1))

#define VMALLOC_START 0xe1000000
#define VMALLOC_END 0xf4ffe000

/* Function prototypes */

/* Callback function after every send */
//void my_send_callback (struct gm_port *port, void *context, gm_status_t status);

/* Function for copying bytes */
void copy_bytes(unsigned char * src, unsigned char * dest,int num_bytes, int start_pos);

/* Function for printing raw bytes */
void print_bytes(FILE * fd, unsigned char * src, int num_bytes, int start_pos);

/* Function compares the src and dest hash values */
int compare_hash(unsigned char * src, unsigned char * dest);

/*Function prints the hash value */
void print_secure_hash(FILE * fd, unsigned char * hash);

/* Functions added for data preprocessing */
void save_data_values(int page_begin, int msmt_round);
void print_data_values();
void read_static_map();
void print_invariants();
//void save_and_compare_raw_pages(int page_begin, int msmt_round);
void populate_start_set();
void fetch_page(unsigned int current_mem_start, int block_no,int msmt_round );
void scan_static_memory(unsigned int mem_start, unsigned int mem_end, int msmt_round);
void scan_dynamic_memory(int msmt_round);
void bfsnodes_from_initroots(queue<entry_t> &bfs_roots);
void build_definition_map();
void build_typedef_index();
page_t get_page(unsigned long long page_addr, int msmt_round);
int get_array_index(const char * ptr);
bool ptr_to_composite_type(string strtype);
string get_container_type(string strtype);
string get_container_field_name(string strtype);
void clear_dmadata_buffer();
void dump_bytes(unsigned char * ptr);
void get_ptrvalues_from_static(int msmt_round);
void handle_reg_ptr_data(symbol_t current_sym, int msmt_round);
unsigned long long virt_to_phys(unsigned long long addr);
unsigned long long page_addr_from_sym_addr(unsigned long long sym_addr);
bool func_ptr(char * s);
void print_definition_map();
void remove_const_keyword(string &sym_type);
bool valid_page(unsigned long long page_addr);
bool in_white_list(char *str);
bool in_black_list(char * str);
void open_filter_file(int msmt_round, string prefix);
void close_filter_file();
string get_daikon_type(string ip_type);
void create_daikon_declaration(vector<field_t> fields, string prefix, int msmt_round, string sym_type);
string replace_spaces(string ip_string);
bool declared(string prefix, int msmt_round);
void load_invariant_list();
void load_obj_invariant_list();
void load_generalized_obj_invariant_list();
char * nullify_rhs(char * ptr);
void load_seq_invariant_list();
void check_invariants(string prefix, vector<fld_ent_t> fields, string pathname);
void check_obj_invariants(string prefix, vector<fld_ent_t> fields, unsigned long long sym_addr, string pathname);
void check_seq_invariants();
bool verify_constant(vector<fld_ent_t> fields, string inv_str);
bool verify_set(vector<fld_ent_t> fields, string inv_str);
bool verify_bounds(vector<fld_ent_t> fields, string inv_str);
void process_linked_lists(int msmt_round);
bool ll_head(char * sym_type);
string remove_chars(string ip_string,char srch);
string replace_with_char(string ip_string,char srch, char with);
char * real_trim(char * str);

/* JEFF ADDITIONS */
/* added for memory map */
unsigned char * build_memory_map(uint32_t domain);
xen_pfn_t * get_p2m_table(int xc_handle, uint32_t dom);
xen_pfn_t * get_m2p_table(int xc_handle, uint32_t dom);
/* added for shadow scan */
void shadow_scan();
unsigned long long virt_to_pfn(unsigned long long addr);
FILE *inv_log;
int static_count;

map<unsigned long long,int> unique_structs;

/*Invariant template function */
bool verify_constant(vector<fld_ent_t> fields, string inv_str);

bool in_static_area(unsigned long long  ptr);
bool list_head(char * ptr);
unsigned long long get_vector_value(vector<unsigned char> bytes);
void print_static_alerts();
void clear_static_data();
void print_stats(int msmt_round, int num_secs);
bool valid_addr(unsigned long long sym_addr);
void log_assert(char * str);
void print_obj_stats(int msmt_round);

/* Functions added for invariant monitoring */

/* Functions added for logging */
void log_init();
void log_finish();
void log(char *msg);
void logln(char *msg);

