#include <stdio.h>
#include <stdlib.h>
#include <sys/mman.h>
#include <sys/resource.h>

#include <xenctrl.h>
#include <xenaccess/xenaccess.h>

#include "xg_save_restore.h"
#include "xg_private.h"

//#define WATCH_LIST_SIZE 262144
#define WATCH_LIST_SIZE 1 

int main(int argc, char **argv)
{
	int xc_handle, frc;
	xc_dominfo_t info;
	uint32_t dom;
	unsigned long p2m_size;
	xc_shadow_op_stats_t stats;
	unsigned long *to_send = NULL;

	/* The new domain's shared-info frame number. */
	unsigned long shared_info_frame;

	/* Live mapping of shared info structure */
	shared_info_any_t *live_shinfo = NULL;

	if(argc == 1)
	{
		printf("USAGE ./mapall <dom_id>\n");
		exit(-1);	
	}

	dom = atoi(argv[1]);
	//address = atoi(argv[2]);
	
	printf("domain: %d\n",dom);

	xc_handle = xc_interface_open();
	
	if(xc_handle == -1)
	{
		fprintf(stderr, "Unable to get handle to hypervisor\n");
		exit(-1);
	}

	p2m_size = xc_memory_op(xc_handle, XENMEM_maximum_gpfn, &dom) + 1;

	/* Live suspend. Enable log-dirty mode. */
	if ( xc_shadow_control(xc_handle, dom,
						XEN_DOMCTL_SHADOW_OP_ENABLE_LOGDIRTY,
						NULL, 0, NULL, 0, NULL) < 0 )
	{
		/* log-dirty already enabled? There's no test op,
			so attempt to disable then reenable it */
		frc = xc_shadow_control(xc_handle, dom, XEN_DOMCTL_SHADOW_OP_OFF,
							NULL, 0, NULL, 0, NULL);
		if ( frc >= 0 )
		{
			frc = xc_shadow_control(xc_handle, dom,
								XEN_DOMCTL_SHADOW_OP_ENABLE_LOGDIRTY,
								NULL, 0, NULL, 0, NULL);
		}
		
		if ( frc < 0 )
		{
			ERROR("Couldn't enable shadow mode (rc %d) (errno %d)", frc, errno );
			exit(-1);
		}
	}

	void *kick_handle = xc_shadow_kick_prepare(xc_handle,dom);

	if(kick_handle == NULL)
	{
		fprintf(stderr, "Unable to get handle to shadow_kick\n");
		exit(-1);
	}

	uint32_t *pfn_watch_list = (uint32_t *)malloc(WATCH_LIST_SIZE*sizeof(uint32_t));
	uint32_t i;
//	for(i=0;i<WATCH_LIST_SIZE;i++){	
//		//pfn_watch_list[i] = 0x358 + i;
//		pfn_watch_list[i] = i;
//	}

	pfn_watch_list[0] = 0x2d3;
	
	int start = xc_shadow_kick_start(kick_handle, pfn_watch_list,WATCH_LIST_SIZE,1);

	printf("kick_start: %d\n",start);

	xc_shadow_kick_wait(kick_handle);

	return 0;
}

