/*
 * Copyright (C) 2005 - 2007  Bryan D. Payne (bryan@thepaynes.cc)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 * --------------------
 * This file provides a simple example for viewing a kernel address in memory.
 *
 * File: map-addr.c
 *
 * Author(s): Bryan D. Payne (bryan@thepaynes.cc)
 */
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/mman.h>
#include <stdio.h>
#include <xenaccess/xenaccess.h>
#include <xenaccess/xa_private.h>

int main (int argc, char **argv)
{
	xa_instance_t xai;
	unsigned char *memory = NULL;
	uint32_t offset;
	uint32_t addr;
	int i;
	char **memory_map;
	
	/* this is the domain ID that we are looking at */
	uint32_t dom = atoi(argv[1]);
	
		
	/* initialize the xen access library */
	if (xa_init_vm_id_strict(dom, &xai) == XA_FAILURE){
		perror("failed to init XenAccess library");
		goto error_exit;
	}

	memory_map = malloc(133120 * sizeof(char *));

	if(memory_map == NULL)
	{
		fprintf(stderr, "Failed to allocate memory for memory_map\n");
		exit(-1);
	}

	for(i = 0; i< 133120;i++){

		addr = 0x1000 * i;
		printf("addr = 0x%.8x i: %i\n",addr,i);
		
		memory = xa_access_pa(&xai, addr, &offset, PROT_READ);
		
		if (NULL == memory){
			perror("failed to map memory");
			goto error_exit;
		}
	
		memory_map[i] = memory;
	}

error_exit:

	/* sanity check to unmap shared pages */
	if (memory) munmap(memory, xai.page_size);
	
	/* cleanup any memory associated with the XenAccess instance */
	xa_destroy(&xai);
	
	return 0;
}

