#!/usr/bin/perl

#Script that runs Daikon on generated .dtrace files and spits out an invariant list
#Sample run command : ./rundaikon.pl <input_dir> <outputfile> <number> <rand_prefix> <config_file>
#

#use strict;
use warnings;
use File::Find;


my $input_dir='input';
my $outfile='outfile';
my $num=3;
my $tmpfile="daikon.tmp." . $ARGV[3];
my $errorfile="daikon.error." . $ARGV[3];
my $cmd_options = ' --config ' . $ARGV[4];
my $dai_cmd='java -Xmx256m daikon.Daikon -o ' . $tmpfile . ' ' . $cmd_options . ' ';

my $cmd = '';
my $chkfile='';

$outfile=$ARGV[1];
$num=$ARGV[2];

my $dai_print='java -Xmx256m daikon.PrintInvariants ' . $tmpfile . ' >> ' . $outfile;

print "Deleting file $outfile\n";
system ("rm -f $outfile");
print "Deleting file $errorfile\n";
system ("rm -f $errorfile");

@decls_files = glob "$ARGV[0]/*.decls";
foreach $decl_file (@decls_files) {
        print "Processing $decl_file \n";

        @decl_prefix = split(/\./, $decl_file);
        $cmd = $dai_cmd . $decl_file . ' ';
        for ($i = 1; $i <= $num; ++$i) {
		$chkfile = $decl_prefix[0] . $i . '.dtrace';

		if(-r $chkfile){
			print "Checking for file [" . $chkfile . "]\n";
                	$cmd .= $decl_prefix[0] . $i . '.dtrace ';
		}
        }
		$cmd .= ' &';
		
        print " Command is: $cmd \n";
        system("$cmd");

	#print "Looking for file " . $tmpfile . "\n";
	#if(-e $tmpfile) {
    #    	system("echo INV_BEGIN >> $outfile");
    #    	system("$dai_print");
    #   		system("echo INV_END >> $outfile");
	#}
	#system ("rm -f $tmpfile");
}

