#include <iostream>
#include <sstream>
#include <map>
#include <vector>

using namespace std;

#define MAX_BUFFER_SIZE 4000 
#define PREFIX "snapshots/dquot"
#define NUM_SNAPSHOTS 19

int main()
{
	FILE * fd1;
	FILE * fd2;
	stringstream filename;

	int objcount1=0;
	int objcount2=0;
	
	filename << PREFIX << "1.dtrace";
	fd1 = fopen(filename.str().c_str(),"r");
	
	if(fd1 == NULL)
	{
		cout << "Cannot open file " << filename.str().c_str()  << endl;
		exit(-1);
	}

	char pp_name[MAX_BUFFER_SIZE];
	char buffer[MAX_BUFFER_SIZE];

	fgets(buffer,MAX_BUFFER_SIZE,fd1);
	map<string, short> inv_map;
	string strppname, strbuffer;

	while(!feof(fd1))
	{
		if (strstr(buffer,":::") != NULL) 
		{
			//Buffer contains ds name
			strcpy(pp_name, buffer);
			strppname = pp_name;
			//Insert it into the map here
			inv_map.insert(make_pair(strppname, 1));
			objcount1++;
		}
		fgets(buffer,MAX_BUFFER_SIZE,fd1);
	}		
	cout << "Objects in file " << filename.str() << " = " << objcount1 << endl;

	FILE * fdout;
	fdout = fopen("obj.common","w");
	if(fdout == NULL)
	{
		cout << "Cannot open file obj.common " << endl;
		exit(-1);
	}

	for(int i=1; i< NUM_SNAPSHOTS; i++)
	{
		stringstream filename;
		filename << PREFIX <<  i << ".dtrace";
		fd2 = fopen(filename.str().c_str(),"r");
	
		cout << filename.str() << endl;
		if(fd2 == NULL)
		{
			cout << "Cannot open file " << filename.str() << endl;
			exit(-1);
		}


		int objcount2 =0;
		int not_found = 0;
    	fgets(buffer,MAX_BUFFER_SIZE,fd2);

		while(!feof(fd2))
    	{
        	if(strstr(buffer,":::") != NULL) 
        	{
            	//Search in the map
				map<string, short>::iterator iter = inv_map.find(strppname);
				//Buffer contains ds name
				strcpy(pp_name, buffer);
				strppname = pp_name;

				if(iter != inv_map.end())
				{
					fprintf(fdout,"%s",pp_name);
					objcount2++;
				}
				else
				{
					not_found++;
				}
			}
        	fgets(buffer,MAX_BUFFER_SIZE,fd2);
		}
		cout << "Objects found in file " << filename.str() << " = " << objcount2 << endl;
		cout << "Objects not found in file " << filename.str() << " = " << not_found << endl;
    }

	fclose(fd1);
	fclose(fdout);
}

