#include "global.h"

/* All utility functions are clubbed in this file */

FILE * fd_log;

void log(char * msg)
{
	fprintf(fd_log,"%s ", msg);	
}

void logln(char * msg)
{
	fprintf(fd_log,"%s\n", msg);	
	fflush(fd_log);
}

/* Opens a file descriptor to the log file and clears the log */
void log_init()
{
	fd_log = fopen("log/log.txt","w");
	if(fd_log == NULL)
	{
		printf("Cannot open log file log/log.txt\n");
		exit(-1);
	}
}

string replace_spaces(string ip_string)
{
    for(int i=0; i<ip_string.size(); i++)
    {
        if(ip_string[i] == ' ')
        {
            ip_string[i] ='_';
        }
    }
    return(ip_string);
}

string replace_with_char(string ip_string,char srch, char with)
{
    for(int i=0; i<ip_string.size(); i++)
    {
        if(ip_string[i] == srch)
        {
            ip_string[i] = with;
        }
    }
    return(ip_string);
}

string remove_chars(string ip_string,char srch)
{
	char buffer[MAX_LINE_INPUT_SIZE];

	int k=0;
    for(int i=0; i<ip_string.size(); i++)
    {
        if(ip_string[i] == srch)
        {
			continue;	
        }
		else
		{
			buffer[k] = ip_string[i];
			k++;
		}
    }
	buffer[k] ='\0';
	ip_string.erase();
	ip_string.assign(buffer);
	cout << ip_string << endl;
    return(ip_string);
}

void log_finish()
{
	fclose(fd_log);
}

char * get_time()
{
  time_t rawtime;
  struct tm * timeinfo;

  time(&rawtime );
  timeinfo = localtime ( &rawtime );
  return(trim(asctime(timeinfo)));
}

char * get_field_info(char * buffer, short field_num)
{
    char l_delimiter =LEFT_FIELD_DELIMITER;
    char r_delimiter =RIGHT_FIELD_DELIMITER;
    short field_counter =0;
    char * ret_buf;
    short start_copying = 0, copied =0;
    int j=0;
    int i;
                                                                                                                                               
    
   // printf("get_field_info %s\n",buffer);
    ret_buf = (char *)malloc(MAX_LINE_INPUT_SIZE);
    for(i=0; i< strlen(buffer); i++)
    {
        if(buffer[i] == l_delimiter)
        {
            field_counter++;
            if(field_counter == field_num) //This is the field to return
            {
                start_copying = 1;
            }
        }
        else if(buffer[i] == r_delimiter)
        {
            if(field_counter == field_num)
            {
                assert(start_copying == 1);
                *(ret_buf + j) = '\0';
                copied = 1;
                break;
            }
        }
        else
        {
            if(start_copying == 1)
            {
                *(char *)(ret_buf + j) = buffer[i];
                                                                                                                                               
                j++;
            }
        }
    }
    if(copied == 1)
        return(ret_buf);
    else
        return(NULL);
}

char * rtrim(char * str)
{
    int i;
                                                                                                                                               
    for(i = (strlen(str) - 1); i >= 0; i--)
    {
        char c = *(char *)(str + i);
                                                                                                                                               
        if((c == ' ') || (c == '\0') || (c == '\n'))
        {
            *(char *)(str + i) = '\0';
        }
        else
        {
            break;
        }
    }
    return(str);
}

char * real_ltrim(char * str)
{
    int i;
                                                                                                                                               
    for(i =0; i < strlen(str); i++)
    {
        char c = *(char *)(str + i);
                                                                                                                                               
		if(c != ' ')
        {
            break;
        }
    }
	
	int k=0;
	for(int j=i; j < (strlen(str) - i + 1); j++)
	{
		str[k] = str[j];
		k++;
	}
	
	*(char *)(str + k) ='\0';
    return(str);
}

char * real_trim(char * str)
{
    return(rtrim(real_ltrim(str)));
}
                                                                                                                                               
/* JEFF CHANGE
char * ltrim(char * str)
{
    int i;
                                                                                                                                               
    for(i =0; i < strlen(str); i++)
    {
        char c = *(char *)(str + i);
                                                                                                                                               
        if((c == ' ') || (c == '\0'))
        {
            *(char *)(str + i) = '\0';
        }
        else
        {
            break;
        }
    }
    return(str);
}  */
char * ltrim(char * str)
{
	int i=0;

	while(i < strlen(str)){
	
		if((str[0] == ' ') || (str[0] == '\0'))
			str++;
		i++;
	}

	return(str);
}
                                                                                                                                               
char * trim(char * str)
{
    return(rtrim(ltrim(str)));
}

int get_array_index(const char * ptr)
{
    char * start_index, * end_index;
    char str_arr_index[5];
    int arr_index;
                                                                                                                                               
    start_index = (char *)index(ptr,'[');
    end_index = (char *)index(ptr, ']');
    int i=0;
                                                                                                                                               
    while(start_index < end_index)
    {
        ++start_index;
        str_arr_index[i++] = *(char *)start_index;
    }
    str_arr_index[i + 1] ='\0';
    arr_index = atoi(str_arr_index);
                                                                                                                                               
    //Check here is array is two dimensional array
    if(strchr(end_index,'[') != NULL)
    {
        //Get the second index
        char str_arr_index2[5];
                                                                                                                                               
        i=0;
        start_index = end_index + 1;
        end_index = strchr(start_index,']');
                                                                                                                                               
        while(start_index < end_index)
        {
            ++start_index;
            str_arr_index2[i++] = *(char *)start_index;
        }
        str_arr_index2[i + 1] ='\0';
        arr_index = arr_index * atoi(str_arr_index2);
    }
                                                                                                                                               
    return(arr_index);
}

bool func_ptr(char * s)
{
    //char func_def[MAX_FIELD_NAME];
    char func_def[MAX_LINE_INPUT_SIZE];
                                                                                                                                               
    if(s != NULL)
    {
        strcpy(func_def, s);
        trim(func_def);
                                                                                                                                               
        int len = strlen(func_def);
                                                                                                                                               
        if((strstr(func_def,"(*)") != NULL) ||
          (((strstr(func_def,"(") != NULL)  && (strstr(func_def,")") != NULL))   && (strstr(func_def,ATTRIBUTE_STRING) == NULL)))
        {
            return(true);
        }
    }
    return(false);
}
