#include <stdio.h>
#include <assert.h>
#include <string.h>

#define MAX_LINE_INPUT_SIZE 500
#define LEFT_FIELD_DELIMITER  '@'
#define RIGHT_FIELD_DELIMITER '|'
char * get_field_info(char * buffer, short field_num);
char * ltrim(char * str);
char * rtrim(char * str);
char * trim(char * str);

// The map generated in input/memory.map.static
int main()
{
	FILE * fd_memmap;
	FILE * fd_out;
	char buffer[MAX_LINE_INPUT_SIZE];
	char old_buffer[MAX_LINE_INPUT_SIZE];

	fd_memmap = fopen("../input/memory.map.static", "r");
	fd_out = fopen("memmap.static.anomalies", "w");

	if(fd_memmap != NULL)
	{
		unsigned long long new_addr = 0;

		fgets(buffer,MAX_LINE_INPUT_SIZE,fd_memmap);

		while(!feof(fd_memmap))
		{
			char * addr;
			char * size;
			unsigned long long ds_addr;
			int ds_size;

			
			printf("buffer=[%s]\n", buffer);
			addr = get_field_info(trim(buffer),1);
			size = get_field_info(trim(buffer),4);			

			ds_addr = strtoll(addr,NULL,16);
			ds_size = strtol(size, NULL,10);

			if(new_addr > 0)
			{
				if(ds_addr != new_addr)
				{
					//Dump the buffer line in outfile
					fprintf(fd_out,"%s\n", old_buffer);
					fprintf(fd_out,"%s\n\n", buffer);
				}
			}


			new_addr = ds_addr + ds_size;
			strcpy(old_buffer,buffer);

			fgets(buffer,MAX_LINE_INPUT_SIZE,fd_memmap);
		}
		fclose(fd_memmap);
		fclose(fd_out);
	}
	
	return 0;
}


char * get_field_info(char * buffer, short field_num)
{
    char l_delimiter =LEFT_FIELD_DELIMITER;
    char r_delimiter =RIGHT_FIELD_DELIMITER;
    short field_counter =0;
    char * ret_buf;
    short start_copying = 0, copied =0;
    int j=0;
    int i;
                                                                                                                                               
    ret_buf = (char *)malloc(MAX_LINE_INPUT_SIZE);
    for(i=0; i< strlen(buffer); i++)
    {
        if(buffer[i] == l_delimiter)
        {
            field_counter++;
            if(field_counter == field_num) //This is the field to return
            {
                start_copying = 1;
            }
        }
        else if(buffer[i] == r_delimiter)
        {
            if(field_counter == field_num)
            {
                assert(start_copying == 1);
                *(ret_buf + j) = '\0';
                copied = 1;
                break;
            }
        }
        else
        {
            if(start_copying == 1)
            {
                *(char *)(ret_buf + j) = buffer[i];
                                                                                                                                               
                j++;
            }
        }
    }
    if(copied == 1)
        return(ret_buf);
    else
        return(NULL);
}

char * rtrim(char * str)
{
    int i;
                                                                                                                                               
    for(i = (strlen(str) - 1); i >= 0; i--)
    {
        char c = *(char *)(str + i);
                                                                                                                                               
        if((c == ' ') || (c == '\0') || (c == '\n'))
        {
            *(char *)(str + i) = '\0';
        }
        else
        {
            break;
        }
    }
    return(str);
}
                                                                                                                                               
char * ltrim(char * str)
{
    int i;
                                                                                                                                               
    for(i =0; i < strlen(str); i++)
    {
        char c = *(char *)(str + i);
                                                                                                                                               
        if((c == ' ') || (c == '\0'))
        {
            *(char *)(str + i) = '\0';
        }
        else
        {
            break;
        }
    }
    return(str);
}
                                                                                                                                               
char * trim(char * str)
{
    return(rtrim(ltrim(str)));
}

